/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.common.collect.Lists;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.AngularCode;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlExpression;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.internal.builder.ElementBuilder;
import com.google.dart.engine.internal.builder.ElementHolder;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.html.angular.AngularExpression;
import com.google.dart.engine.internal.html.angular.AngularFilterArgument;
import com.google.dart.engine.internal.html.angular.AngularFilterNode;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.NgDirectiveProcessor;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NgRepeatProcessor
extends NgDirectiveProcessor {
    private static final String NG_REPEAT = "ng-repeat";
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("^\\s*(.+)\\s+in\\s+(.+?)\\s*(\\s+track\\s+by\\s+(.+)\\s*)?(\\s+lazily\\s*)?$");
    private static final Pattern LHS_PATTERN = Pattern.compile("^(?:([\\$\\w]+)|\\(([\\$\\w]+)\\s*,\\s*([\\$\\w]+)\\))$");
    public static final NgRepeatProcessor INSTANCE = new NgRepeatProcessor();

    private NgRepeatProcessor() {
    }

    @Override
    public void apply(AngularHtmlUnitResolver angularHtmlUnitResolver, XmlTagNode xmlTagNode) {
        XmlAttributeNode xmlAttributeNode = xmlTagNode.getAttribute(NG_REPEAT);
        int n = xmlAttributeNode.getValueToken().getOffset() + 1;
        String string = xmlAttributeNode.getText();
        Matcher matcher = SYNTAX_PATTERN.matcher(string);
        if (!matcher.matches()) {
            angularHtmlUnitResolver.reportErrorForOffset(AngularCode.INVALID_REPEAT_SYNTAX, n, string.length() - 2, new Object[0]);
            return;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(4);
        int n2 = n + matcher.start(1);
        int n3 = n + matcher.start(2);
        int n4 = n + matcher.start(4);
        ArrayList<XmlExpression> arrayList = Lists.newArrayList();
        Matcher matcher2 = LHS_PATTERN.matcher(string2);
        if (!matcher2.matches()) {
            angularHtmlUnitResolver.reportErrorForOffset(AngularCode.INVALID_REPEAT_ITEM_SYNTAX, n2, string2.length(), new Object[0]);
            return;
        }
        Expression expression = angularHtmlUnitResolver.parseDartExpression(string2, 0, string2.length(), n2);
        SimpleIdentifier simpleIdentifier = (SimpleIdentifier)expression;
        AngularExpression angularExpression = angularHtmlUnitResolver.parseAngularExpression(string3, 0, string3.length(), n3);
        DeclaredIdentifier declaredIdentifier = new DeclaredIdentifier(null, null, null, null, simpleIdentifier);
        Block block = new Block(null, new ArrayList<Statement>(), null);
        ForEachStatement forEachStatement = new ForEachStatement(null, null, declaredIdentifier, null, angularExpression.getExpression(), null, (Statement)block);
        new ElementBuilder(new ElementHolder()).visitDeclaredIdentifier(declaredIdentifier);
        angularHtmlUnitResolver.resolveNode(forEachStatement);
        Type type = simpleIdentifier.getBestType();
        Object object = (LocalVariableElementImpl)simpleIdentifier.getStaticElement();
        ((VariableElementImpl)object).setType(type);
        angularHtmlUnitResolver.defineVariable((LocalVariableElementImpl)object);
        this.resolveFilters(angularHtmlUnitResolver, angularExpression, type);
        arrayList.add(NgRepeatProcessor.newRawXmlExpression(expression));
        arrayList.add(NgRepeatProcessor.newAngularRawXmlExpression(angularExpression));
        if (string4 != null) {
            object = angularHtmlUnitResolver.parseAngularExpression(string4, 0, string4.length(), n4);
            arrayList.add(NgRepeatProcessor.newAngularRawXmlExpression((AngularExpression)object));
        }
        this.setExpressions(xmlAttributeNode, arrayList);
        this.defineLocalVariable_int(angularHtmlUnitResolver, "$index");
        this.defineLocalVariable_bool(angularHtmlUnitResolver, "$first");
        this.defineLocalVariable_bool(angularHtmlUnitResolver, "$middle");
        this.defineLocalVariable_bool(angularHtmlUnitResolver, "$last");
        this.defineLocalVariable_bool(angularHtmlUnitResolver, "$even");
        this.defineLocalVariable_bool(angularHtmlUnitResolver, "$odd");
    }

    @Override
    public boolean canApply(XmlTagNode xmlTagNode) {
        return xmlTagNode.getAttribute(NG_REPEAT) != null;
    }

    private void defineLocalVariable_bool(AngularHtmlUnitResolver angularHtmlUnitResolver, String string) {
        InterfaceType interfaceType = angularHtmlUnitResolver.getTypeProvider().getBoolType();
        LocalVariableElementImpl localVariableElementImpl = angularHtmlUnitResolver.createLocalVariableWithName(interfaceType, string);
        angularHtmlUnitResolver.defineVariable(localVariableElementImpl);
    }

    private void defineLocalVariable_int(AngularHtmlUnitResolver angularHtmlUnitResolver, String string) {
        InterfaceType interfaceType = angularHtmlUnitResolver.getTypeProvider().getIntType();
        LocalVariableElementImpl localVariableElementImpl = angularHtmlUnitResolver.createLocalVariableWithName(interfaceType, string);
        angularHtmlUnitResolver.defineVariable(localVariableElementImpl);
    }

    private void resolveFilterArgument_filter(AngularHtmlUnitResolver angularHtmlUnitResolver, Type type, AngularFilterArgument angularFilterArgument, int n) {
        Expression expression = angularFilterArgument.getExpression();
        if (n != 0) {
            angularHtmlUnitResolver.resolveNode(expression);
            return;
        }
        if (expression instanceof MapLiteral) {
            ArrayList<Expression> arrayList = Lists.newArrayList();
            NodeList<MapLiteralEntry> nodeList = ((MapLiteral)expression).getEntries();
            for (MapLiteralEntry mapLiteralEntry : nodeList) {
                Expression expression2 = mapLiteralEntry.getKey();
                if (!(expression2 instanceof SimpleIdentifier)) continue;
                SimpleIdentifier simpleIdentifier = (SimpleIdentifier)expression2;
                this.resolvePropertyNode(angularHtmlUnitResolver, arrayList, type, simpleIdentifier);
            }
            angularFilterArgument.setSubExpressions(arrayList.toArray(new Expression[arrayList.size()]));
        }
    }

    private void resolveFilterArgument_orderBy(AngularHtmlUnitResolver angularHtmlUnitResolver, List<Expression> list, Type type, Expression expression, int n) {
        if (expression instanceof ListLiteral) {
            NodeList<Expression> nodeList = ((ListLiteral)expression).getElements();
            for (Expression expression2 : nodeList) {
                this.resolveFilterArgument_orderBy(angularHtmlUnitResolver, list, type, expression2, 0);
            }
            return;
        }
        if (expression instanceof SimpleStringLiteral) {
            SimpleStringLiteral simpleStringLiteral = (SimpleStringLiteral)expression;
            String string = simpleStringLiteral.getStringValue();
            int n2 = simpleStringLiteral.getValueOffset();
            if (StringUtilities.startsWithChar(string, 43)) {
                string = string.substring(1);
                ++n2;
            } else if (StringUtilities.startsWithChar(string, 45)) {
                string = string.substring(1);
                ++n2;
            }
            if (string.isEmpty()) {
                return;
            }
            expression = angularHtmlUnitResolver.parseDartExpression(string, 0, string.length(), n2);
            if (expression instanceof SimpleIdentifier) {
                SimpleIdentifier simpleIdentifier = (SimpleIdentifier)expression;
                this.resolvePropertyNode(angularHtmlUnitResolver, list, type, simpleIdentifier);
            }
        }
    }

    private void resolveFilterArgument_orderByWithFilter(AngularHtmlUnitResolver angularHtmlUnitResolver, Type type, AngularFilterArgument angularFilterArgument, int n) {
        Expression expression = angularFilterArgument.getExpression();
        if (n != 0) {
            angularHtmlUnitResolver.resolveNode(expression);
            return;
        }
        ArrayList<Expression> arrayList = Lists.newArrayList();
        this.resolveFilterArgument_orderBy(angularHtmlUnitResolver, arrayList, type, expression, 0);
        angularFilterArgument.setSubExpressions(arrayList.toArray(new Expression[arrayList.size()]));
    }

    private void resolveFilterArguments(AngularHtmlUnitResolver angularHtmlUnitResolver, Type type, String string, List<AngularFilterArgument> list) {
        int n = 0;
        for (AngularFilterArgument angularFilterArgument : list) {
            if ("filter".equals(string)) {
                this.resolveFilterArgument_filter(angularHtmlUnitResolver, type, angularFilterArgument, n);
            }
            if ("orderBy".equals(string)) {
                this.resolveFilterArgument_orderByWithFilter(angularHtmlUnitResolver, type, angularFilterArgument, n);
            }
            ++n;
        }
    }

    private void resolveFilters(AngularHtmlUnitResolver angularHtmlUnitResolver, AngularExpression angularExpression, Type type) {
        for (AngularFilterNode angularFilterNode : angularExpression.getFilters()) {
            SimpleIdentifier simpleIdentifier = angularFilterNode.getName();
            String string = simpleIdentifier.getName();
            simpleIdentifier.setStaticElement(angularHtmlUnitResolver.findAngularElement(string));
            this.resolveFilterArguments(angularHtmlUnitResolver, type, string, angularFilterNode.getArguments());
        }
    }

    private void resolvePropertyNode(AngularHtmlUnitResolver angularHtmlUnitResolver, List<Expression> list, Type type, SimpleIdentifier simpleIdentifier) {
        if (type instanceof InterfaceType) {
            String string = simpleIdentifier.getName();
            PropertyAccessorElement propertyAccessorElement = ((InterfaceType)type).getGetter(string);
            if (propertyAccessorElement != null) {
                simpleIdentifier.setStaticElement(propertyAccessorElement);
            }
        } else {
            Type type2 = angularHtmlUnitResolver.getTypeProvider().getDynamicType();
            simpleIdentifier.setStaticElement(type2.getElement());
            simpleIdentifier.setStaticType(type2);
        }
        list.add(simpleIdentifier);
    }
}

