/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.NgDirectiveProcessor;
import com.google.dart.engine.type.InterfaceType;

class NgModelProcessor
extends NgDirectiveProcessor {
    private static final String NG_MODEL = "ng-model";
    public static final NgModelProcessor INSTANCE = new NgModelProcessor();

    private NgModelProcessor() {
    }

    @Override
    public void apply(AngularHtmlUnitResolver angularHtmlUnitResolver, XmlTagNode xmlTagNode) {
        XmlAttributeNode xmlAttributeNode = xmlTagNode.getAttribute(NG_MODEL);
        Expression expression = this.parseDartExpression(angularHtmlUnitResolver, xmlAttributeNode);
        if (expression instanceof SimpleIdentifier) {
            return;
        }
        angularHtmlUnitResolver.resolveNode(expression);
        this.setExpression(xmlAttributeNode, expression);
    }

    @Override
    public boolean canApply(XmlTagNode xmlTagNode) {
        return xmlTagNode.getAttribute(NG_MODEL) != null;
    }

    void applyTopDeclarations(AngularHtmlUnitResolver angularHtmlUnitResolver, XmlTagNode xmlTagNode) {
        XmlAttributeNode xmlAttributeNode = xmlTagNode.getAttribute(NG_MODEL);
        Expression expression = this.parseDartExpression(angularHtmlUnitResolver, xmlAttributeNode);
        if (!(expression instanceof SimpleIdentifier)) {
            return;
        }
        SimpleIdentifier simpleIdentifier = (SimpleIdentifier)expression;
        InterfaceType interfaceType = angularHtmlUnitResolver.getTypeProvider().getStringType();
        LocalVariableElementImpl localVariableElementImpl = angularHtmlUnitResolver.createLocalVariableFromIdentifier(interfaceType, simpleIdentifier);
        angularHtmlUnitResolver.defineTopVariable(localVariableElementImpl);
        simpleIdentifier.setStaticElement(localVariableElementImpl);
        simpleIdentifier.setStaticType(interfaceType);
        this.setExpression(xmlAttributeNode, simpleIdentifier);
    }
}

