/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.angular.AngularDirectiveElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.element.angular.AngularPropertyKind;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.internal.element.angular.HasAttributeSelectorElementImpl;
import com.google.dart.engine.internal.html.angular.AngularExpression;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.NgDirectiveProcessor;
import com.google.dart.engine.type.Type;

class NgDirectiveElementProcessor
extends NgDirectiveProcessor {
    private final AngularDirectiveElement element;

    public NgDirectiveElementProcessor(AngularDirectiveElement angularDirectiveElement) {
        this.element = angularDirectiveElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(AngularHtmlUnitResolver angularHtmlUnitResolver, XmlTagNode xmlTagNode) {
        XmlAttributeNode xmlAttributeNode;
        String string = null;
        AngularPropertyElement[] angularPropertyElementArray = this.element.getSelector();
        if (angularPropertyElementArray instanceof HasAttributeSelectorElementImpl && (xmlAttributeNode = xmlTagNode.getAttribute(string = ((HasAttributeSelectorElementImpl)angularPropertyElementArray).getName())) != null) {
            xmlAttributeNode.setElement((Element)angularPropertyElementArray);
        }
        for (AngularPropertyElement angularPropertyElement : this.element.getProperties()) {
            XmlAttributeNode xmlAttributeNode2;
            String string2 = angularPropertyElement.getName();
            if (string2.equals(".")) {
                string2 = string;
            }
            if ((xmlAttributeNode2 = xmlTagNode.getAttribute(string2)) == null) continue;
            if (!string2.equals(string)) {
                xmlAttributeNode2.setElement(angularPropertyElement);
            }
            if (!NgDirectiveElementProcessor.hasValue(xmlAttributeNode2) || angularPropertyElement.getPropertyKind() == AngularPropertyKind.ATTR) continue;
            angularHtmlUnitResolver.pushNameScope();
            try {
                this.onNgEventDirective(angularHtmlUnitResolver);
                AngularExpression angularExpression = this.parseAngularExpression(angularHtmlUnitResolver, xmlAttributeNode2);
                angularHtmlUnitResolver.resolveExpression(angularExpression);
                this.setAngularExpression(xmlAttributeNode2, angularExpression);
            }
            finally {
                angularHtmlUnitResolver.popNameScope();
            }
        }
    }

    @Override
    public boolean canApply(XmlTagNode xmlTagNode) {
        return this.element.getSelector().apply(xmlTagNode);
    }

    private void onNgEventDirective(AngularHtmlUnitResolver angularHtmlUnitResolver) {
        if (this.element.isClass("NgEventDirective")) {
            Type type = angularHtmlUnitResolver.getTypeProvider().getDynamicType();
            angularHtmlUnitResolver.defineVariable(angularHtmlUnitResolver.createLocalVariableWithName(type, "$event"));
        }
    }
}

