/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.element.angular.AngularPropertyKind;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.internal.html.angular.AngularExpression;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.NgDirectiveProcessor;

class NgComponentElementProcessor
extends NgDirectiveProcessor {
    private final AngularComponentElement element;

    public NgComponentElementProcessor(AngularComponentElement angularComponentElement) {
        this.element = angularComponentElement;
    }

    @Override
    public void apply(AngularHtmlUnitResolver angularHtmlUnitResolver, XmlTagNode xmlTagNode) {
        xmlTagNode.setElement(this.element.getSelector());
        for (AngularPropertyElement angularPropertyElement : this.element.getProperties()) {
            String string = angularPropertyElement.getName();
            XmlAttributeNode xmlAttributeNode = xmlTagNode.getAttribute(string);
            if (xmlAttributeNode == null) continue;
            xmlAttributeNode.setElement(angularPropertyElement);
            if (angularPropertyElement.getPropertyKind() == AngularPropertyKind.ATTR) continue;
            AngularExpression angularExpression = this.parseAngularExpression(angularHtmlUnitResolver, xmlAttributeNode);
            angularHtmlUnitResolver.resolveExpression(angularExpression);
            this.setAngularExpression(xmlAttributeNode, angularExpression);
        }
    }

    @Override
    public boolean canApply(XmlTagNode xmlTagNode) {
        return this.element.getSelector().apply(xmlTagNode);
    }
}

