/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.visitor.ElementLocator;
import com.google.dart.engine.ast.visitor.NodeLocator;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.html.ast.XmlExpression;
import com.google.dart.engine.internal.html.angular.AngularExpression;
import com.google.dart.engine.internal.html.angular.AngularFilterArgument;
import com.google.dart.engine.internal.html.angular.AngularFilterNode;

public abstract class AngularXmlExpression
extends XmlExpression {
    protected final AngularExpression expression;

    public AngularXmlExpression(AngularExpression angularExpression) {
        this.expression = angularExpression;
    }

    public AngularExpression getExpression() {
        return this.expression;
    }

    @Override
    public XmlExpression.Reference getReference(int n) {
        XmlExpression.Reference reference = this.getReferenceAtNode(this.expression.getExpression(), n);
        if (reference != null) {
            return reference;
        }
        for (AngularFilterNode angularFilterNode : this.expression.getFilters()) {
            reference = this.getReferenceAtNode(angularFilterNode.getName(), n);
            if (reference != null) {
                return reference;
            }
            for (AngularFilterArgument angularFilterArgument : angularFilterNode.getArguments()) {
                reference = this.getReferenceAtNode(angularFilterArgument.getExpression(), n);
                if (reference == null) continue;
                return reference;
            }
        }
        return null;
    }

    private XmlExpression.Reference getReferenceAtNode(AstNode astNode, int n) {
        AstNode astNode2 = new NodeLocator(n).searchWithin(astNode);
        if (astNode2 != null) {
            Element element = ElementLocator.locate(astNode2);
            return new XmlExpression.Reference(element, astNode2.getOffset(), astNode2.getLength());
        }
        return null;
    }
}

