/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExternalHtmlScriptElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.HtmlScriptElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.element.UriReferencedElement;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularControllerElement;
import com.google.dart.engine.element.angular.AngularDirectiveElement;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.element.angular.AngularFilterElement;
import com.google.dart.engine.element.angular.AngularHasTemplateElement;
import com.google.dart.engine.element.angular.AngularScopePropertyElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.AngularCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlExpression;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.RecursiveXmlVisitor;
import com.google.dart.engine.html.parser.HtmlParser;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.element.CompilationUnitElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.HtmlElementImpl;
import com.google.dart.engine.internal.element.ImportElementImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.internal.element.angular.AngularComponentElementImpl;
import com.google.dart.engine.internal.element.angular.AngularElementImpl;
import com.google.dart.engine.internal.element.angular.AngularViewElementImpl;
import com.google.dart.engine.internal.html.angular.AngularExpression;
import com.google.dart.engine.internal.html.angular.AngularFilterArgument;
import com.google.dart.engine.internal.html.angular.AngularFilterNode;
import com.google.dart.engine.internal.html.angular.AngularMoustacheXmlExpression;
import com.google.dart.engine.internal.html.angular.AngularXmlExpression;
import com.google.dart.engine.internal.html.angular.NgComponentElementProcessor;
import com.google.dart.engine.internal.html.angular.NgControllerElementProcessor;
import com.google.dart.engine.internal.html.angular.NgDirectiveElementProcessor;
import com.google.dart.engine.internal.html.angular.NgModelProcessor;
import com.google.dart.engine.internal.html.angular.NgProcessor;
import com.google.dart.engine.internal.html.angular.NgRepeatProcessor;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.internal.resolver.ProxyConditionalAnalysisError;
import com.google.dart.engine.internal.resolver.ResolverVisitor;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Scope;
import com.google.dart.engine.parser.Parser;
import com.google.dart.engine.scanner.StringToken;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.general.StringUtilities;
import com.google.dart.engine.utilities.source.LineInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AngularHtmlUnitResolver
extends RecursiveXmlVisitor<Void> {
    private static final String NG_APP = "ng-app";
    private final InternalAnalysisContext context;
    private final TypeProvider typeProvider;
    private final FilteringAnalysisErrorListener errorListener;
    private final Source source;
    private final LineInfo lineInfo;
    private final HtmlUnit unit;
    private AngularElement[] angularElements;
    private final List<NgProcessor> processors = Lists.newArrayList();
    private LibraryElementImpl libraryElement;
    private CompilationUnitElementImpl unitElement;
    private FunctionElementImpl functionElement;
    private ResolverVisitor resolver;
    private boolean isAngular = false;
    private List<LocalVariableElementImpl> definedVariables = Lists.newArrayList();
    private Set<LibraryElement> injectedLibraries = Sets.newHashSet();
    private Scope topNameScope;
    private Scope nameScope;

    public static AngularElement getAngularElement(Element element) {
        LocalVariableElement localVariableElement;
        ToolkitObjectElement[] toolkitObjectElementArray;
        if (element instanceof LocalVariableElement && (toolkitObjectElementArray = (localVariableElement = (LocalVariableElement)element).getToolkitObjects()).length == 1 && toolkitObjectElementArray[0] instanceof AngularElement) {
            return (AngularElement)toolkitObjectElementArray[0];
        }
        return null;
    }

    public static boolean hasAngularAnnotation(HtmlUnit htmlUnit) {
        try {
            htmlUnit.accept(new RecursiveXmlVisitor<Void>(){

                @Override
                public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
                    if (xmlTagNode.getAttribute(AngularHtmlUnitResolver.NG_APP) != null) {
                        throw new FoundAppError();
                    }
                    return (Void)super.visitXmlTagNode(xmlTagNode);
                }
            });
        }
        catch (FoundAppError foundAppError) {
            return true;
        }
        return false;
    }

    static SimpleIdentifier createIdentifier(String string, int n) {
        StringToken stringToken = AngularHtmlUnitResolver.createStringToken(string, n);
        return new SimpleIdentifier(stringToken);
    }

    private static void addAngularElementsFromClass(Set<AngularElement> set, ClassElement classElement) {
        for (ToolkitObjectElement toolkitObjectElement : classElement.getToolkitObjects()) {
            if (!(toolkitObjectElement instanceof AngularElement)) continue;
            set.add((AngularElement)toolkitObjectElement);
        }
    }

    private static void addAngularElementsFromLibrary(Set<AngularElement> set, LibraryElement libraryElement, Set<LibraryElement> set2) {
        if (libraryElement == null) {
            return;
        }
        if (!set2.add(libraryElement)) {
            return;
        }
        for (CompilationUnitElement uriReferencedElement : libraryElement.getUnits()) {
            Collections.addAll(set, uriReferencedElement.getAngularViews());
            for (ClassElement classElement : uriReferencedElement.getTypes()) {
                AngularHtmlUnitResolver.addAngularElementsFromClass(set, classElement);
            }
        }
        for (UriReferencedElement uriReferencedElement : libraryElement.getImports()) {
            LibraryElement libraryElement2 = uriReferencedElement.getImportedLibrary();
            AngularHtmlUnitResolver.addAngularElementsFromLibrary(set, libraryElement2, set2);
        }
    }

    private static StringToken createStringToken(String string, int n) {
        return new StringToken(TokenType.IDENTIFIER, string, n);
    }

    private static AngularElement[] getAngularElements(Set<LibraryElement> set, LibraryElement libraryElement) {
        HashSet<AngularElement> hashSet = Sets.newHashSet();
        AngularHtmlUnitResolver.addAngularElementsFromLibrary(hashSet, libraryElement, set);
        return hashSet.toArray(new AngularElement[hashSet.size()]);
    }

    private static CompilationUnit getDartUnit(AnalysisContext analysisContext, HtmlUnit htmlUnit) throws AnalysisException {
        for (HtmlScriptElement htmlScriptElement : htmlUnit.getElement().getScripts()) {
            Source source;
            if (!(htmlScriptElement instanceof ExternalHtmlScriptElement) || (source = ((ExternalHtmlScriptElement)htmlScriptElement).getScriptSource()) == null) continue;
            return analysisContext.resolveCompilationUnit(source, source);
        }
        return null;
    }

    private static Set<Source> getLibrarySources(Set<LibraryElement> set) {
        HashSet<Source> hashSet = Sets.newHashSet();
        for (LibraryElement libraryElement : set) {
            hashSet.add(libraryElement.getSource());
        }
        return hashSet;
    }

    public AngularHtmlUnitResolver(InternalAnalysisContext internalAnalysisContext, AnalysisErrorListener analysisErrorListener, Source source, LineInfo lineInfo, HtmlUnit htmlUnit) throws AnalysisException {
        this.context = internalAnalysisContext;
        this.typeProvider = internalAnalysisContext.getTypeProvider();
        this.errorListener = new FilteringAnalysisErrorListener(analysisErrorListener);
        this.source = source;
        this.lineInfo = lineInfo;
        this.unit = htmlUnit;
    }

    public AngularApplication calculateAngularApplication() throws AnalysisException {
        if (!AngularHtmlUnitResolver.hasAngularAnnotation(this.unit)) {
            return null;
        }
        CompilationUnit compilationUnit = AngularHtmlUnitResolver.getDartUnit(this.context, this.unit);
        if (compilationUnit == null) {
            return null;
        }
        LibraryElement libraryElement = compilationUnit.getElement().getLibrary();
        HashSet<LibraryElement> hashSet = Sets.newHashSet();
        AngularElement[] angularElementArray = AngularHtmlUnitResolver.getAngularElements(hashSet, libraryElement);
        HashSet<Source> hashSet2 = Sets.newHashSet();
        for (AngularElement angularElement : angularElementArray) {
            if (!(angularElement instanceof AngularHasTemplateElement)) continue;
            AngularElement angularElement2 = (AngularHasTemplateElement)angularElement;
            hashSet2.add(angularElement.getSource());
            String string = angularElement2.getTemplateUri();
            if (string == null) continue;
            try {
                Source uRISyntaxException = this.source.resolveRelative(new URI(string));
                if (!this.context.exists(uRISyntaxException) && !this.context.exists(uRISyntaxException = this.context.getSourceFactory().resolveUri(this.source, "package:" + string))) {
                    this.errorListener.onError(new AnalysisError(angularElement.getSource(), angularElement2.getTemplateUriOffset(), string.length(), AngularCode.URI_DOES_NOT_EXIST, string));
                    continue;
                }
                if (!AnalysisEngine.isHtmlFileName(string)) continue;
                if (angularElement2 instanceof AngularComponentElementImpl) {
                    ((AngularComponentElementImpl)angularElement2).setTemplateSource(uRISyntaxException);
                }
                if (!(angularElement2 instanceof AngularViewElementImpl)) continue;
                ((AngularViewElementImpl)angularElement2).setTemplateSource(uRISyntaxException);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.errorListener.onError(new AnalysisError(angularElement.getSource(), angularElement2.getTemplateUriOffset(), string.length(), AngularCode.INVALID_URI, string));
            }
        }
        AngularApplication angularApplication = new AngularApplication(this.source, AngularHtmlUnitResolver.getLibrarySources(hashSet), angularElementArray, hashSet2.toArray(new Source[hashSet2.size()]));
        for (AngularElement angularElement2 : angularElementArray) {
            ((AngularElementImpl)angularElement2).setApplication(angularApplication);
        }
        return angularApplication;
    }

    public void resolveComponentTemplate(AngularApplication angularApplication, AngularComponentElement angularComponentElement) throws AnalysisException {
        this.isAngular = true;
        this.resolveInternal(angularApplication.getElements(), angularComponentElement);
    }

    public void resolveEntryPoint(AngularApplication angularApplication) throws AnalysisException {
        this.resolveInternal(angularApplication.getElements(), null);
    }

    @Override
    public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
        this.parseEmbeddedExpressionsInAttribute(xmlAttributeNode);
        this.resolveExpressions(xmlAttributeNode.getExpressions());
        return (Void)super.visitXmlAttributeNode(xmlAttributeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
        boolean bl = this.isAngular;
        try {
            if (xmlTagNode.getAttribute(NG_APP) != null) {
                this.isAngular = true;
                this.visitModelDirectives(xmlTagNode);
            }
            if (!this.isAngular) {
                Void void_ = (Void)super.visitXmlTagNode(xmlTagNode);
                return void_;
            }
            this.pushNameScope();
            try {
                this.parseEmbeddedExpressionsInTag(xmlTagNode);
                for (NgProcessor ngProcessor : this.processors) {
                    if (!ngProcessor.canApply(xmlTagNode)) continue;
                    ngProcessor.apply(this, xmlTagNode);
                }
                this.resolveExpressions(xmlTagNode.getExpressions());
                Void void_ = (Void)super.visitXmlTagNode(xmlTagNode);
                this.popNameScope();
                return void_;
            }
            catch (Throwable throwable) {
                this.popNameScope();
                throw throwable;
            }
        }
        finally {
            this.isAngular = bl;
        }
    }

    LocalVariableElementImpl createLocalVariableFromIdentifier(Type type, SimpleIdentifier simpleIdentifier) {
        LocalVariableElementImpl localVariableElementImpl = new LocalVariableElementImpl(simpleIdentifier);
        this.definedVariables.add(localVariableElementImpl);
        localVariableElementImpl.setType(type);
        return localVariableElementImpl;
    }

    LocalVariableElementImpl createLocalVariableWithName(Type type, String string) {
        SimpleIdentifier simpleIdentifier = AngularHtmlUnitResolver.createIdentifier(string, 0);
        return this.createLocalVariableFromIdentifier(type, simpleIdentifier);
    }

    void defineTopVariable(LocalVariableElementImpl localVariableElementImpl) {
        this.recordDefinedVariable(localVariableElementImpl);
        this.topNameScope.define(localVariableElementImpl);
        this.recordTypeLibraryInjected(localVariableElementImpl);
    }

    void defineVariable(LocalVariableElementImpl localVariableElementImpl) {
        this.recordDefinedVariable(localVariableElementImpl);
        this.nameScope.define(localVariableElementImpl);
        this.recordTypeLibraryInjected(localVariableElementImpl);
    }

    AngularElement findAngularElement(String string) {
        for (AngularElement angularElement : this.angularElements) {
            if (!string.equals(angularElement.getName())) continue;
            return angularElement;
        }
        return null;
    }

    TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    AngularExpression parseAngularExpression(String string, int n, int n2, int n3) {
        com.google.dart.engine.scanner.Token token = this.scanDart(string, n, n2, n3);
        return this.parseAngularExpressionInToken(token);
    }

    AngularExpression parseAngularExpressionInToken(com.google.dart.engine.scanner.Token token) {
        List<com.google.dart.engine.scanner.Token> list = this.splitAtBar(token);
        Expression expression = this.parseDartExpressionInToken(list.get(0));
        ArrayList<AngularFilterNode> arrayList = Lists.newArrayList();
        for (int i = 1; i < list.size(); ++i) {
            com.google.dart.engine.scanner.Token token2;
            com.google.dart.engine.scanner.Token token3 = token2 = list.get(i);
            token2 = token2.getNext();
            SimpleIdentifier simpleIdentifier = (SimpleIdentifier)this.parseDartExpressionInToken(token2);
            token2 = simpleIdentifier.getEndToken().getNext();
            ArrayList<AngularFilterArgument> arrayList2 = Lists.newArrayList();
            while (token2.getType() != TokenType.EOF) {
                com.google.dart.engine.scanner.Token token4 = token2;
                if (token4.getType() == TokenType.COLON) {
                    token2 = token2.getNext();
                } else {
                    this.reportErrorForToken(AngularCode.MISSING_FILTER_COLON, token4, new Object[0]);
                }
                Expression expression2 = this.parseDartExpressionInToken(token2);
                arrayList2.add(new AngularFilterArgument(token4, expression2));
                token2 = expression2.getEndToken().getNext();
            }
            arrayList.add(new AngularFilterNode(token3, simpleIdentifier, arrayList2));
        }
        return new AngularExpression(expression, arrayList);
    }

    Expression parseDartExpression(String string, int n, int n2, int n3) {
        com.google.dart.engine.scanner.Token token = this.scanDart(string, n, n2, n3);
        return this.parseDartExpressionInToken(token);
    }

    Expression parseDartExpressionInToken(com.google.dart.engine.scanner.Token token) {
        Parser parser = new Parser(this.source, this.errorListener);
        return parser.parseExpression(token);
    }

    void popNameScope() {
        this.nameScope = this.resolver.popNameScope();
    }

    void pushNameScope() {
        this.nameScope = this.resolver.pushNameScope();
    }

    void reportErrorForNode(ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        this.reportErrorForOffset(errorCode, astNode.getOffset(), astNode.getLength(), objectArray);
    }

    void reportErrorForOffset(ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, n, n2, errorCode, objectArray));
    }

    void reportErrorForToken(ErrorCode errorCode, com.google.dart.engine.scanner.Token token, Object ... objectArray) {
        this.reportErrorForOffset(errorCode, token.getOffset(), token.getLength(), objectArray);
    }

    void resolveExpression(AngularExpression angularExpression) {
        List<Expression> list = angularExpression.getExpressions();
        for (Expression expression : list) {
            this.resolveNode(expression);
        }
    }

    void resolveNode(AstNode astNode) {
        astNode.accept(this.resolver);
    }

    com.google.dart.engine.scanner.Token scanDart(String string, int n, int n2, int n3) {
        return HtmlParser.scanDartSource(this.source, this.lineInfo, string.substring(n, n2), n3 + n, this.errorListener);
    }

    private void createLibraryElement() {
        String string = this.source.getShortName();
        this.unitElement = new CompilationUnitElementImpl(string);
        this.unitElement.setSource(this.source);
        this.libraryElement = new LibraryElementImpl(this.context, null);
        this.libraryElement.setDefiningCompilationUnit(this.unitElement);
        this.libraryElement.setAngularHtml(true);
        this.injectedLibraries.add(this.libraryElement);
        this.functionElement = new FunctionElementImpl(0);
        this.unitElement.setFunctions(new FunctionElement[]{this.functionElement});
    }

    private NgProcessor createProcessor(AngularElement angularElement) {
        if (angularElement instanceof AngularComponentElement) {
            AngularComponentElement angularComponentElement = (AngularComponentElement)angularElement;
            return new NgComponentElementProcessor(angularComponentElement);
        }
        if (angularElement instanceof AngularControllerElement) {
            AngularControllerElement angularControllerElement = (AngularControllerElement)angularElement;
            return new NgControllerElementProcessor(angularControllerElement);
        }
        if (angularElement instanceof AngularDirectiveElement) {
            AngularDirectiveElement angularDirectiveElement = (AngularDirectiveElement)angularElement;
            return new NgDirectiveElementProcessor(angularDirectiveElement);
        }
        return null;
    }

    private void createResolver() {
        InheritanceManager inheritanceManager = new InheritanceManager(this.libraryElement);
        this.resolver = new ResolverVisitor((LibraryElement)this.libraryElement, this.source, this.typeProvider, inheritanceManager, (AnalysisErrorListener)this.errorListener);
        this.topNameScope = this.resolver.pushNameScope();
        Type type = this.typeProvider.getDynamicType();
        this.topNameScope.define(this.createLocalVariableWithName(type, "$id"));
        this.topNameScope.define(this.createLocalVariableWithName(type, "$parent"));
        this.topNameScope.define(this.createLocalVariableWithName(type, "$root"));
    }

    private void defineTopVariable_forClassElement(AngularElement angularElement) {
        ClassElement classElement = (ClassElement)angularElement.getEnclosingElement();
        InterfaceType interfaceType = classElement.getType();
        LocalVariableElementImpl localVariableElementImpl = this.createLocalVariableWithName(interfaceType, angularElement.getName());
        this.defineTopVariable(localVariableElementImpl);
        localVariableElementImpl.setToolkitObjects(new AngularElement[]{angularElement});
    }

    private void defineTopVariable_forScopeProperty(AngularScopePropertyElement angularScopePropertyElement) {
        Type type = angularScopePropertyElement.getType();
        LocalVariableElementImpl localVariableElementImpl = this.createLocalVariableWithName(type, angularScopePropertyElement.getName());
        this.defineTopVariable(localVariableElementImpl);
        localVariableElementImpl.setToolkitObjects(new AngularElement[]{angularScopePropertyElement});
    }

    private void parseEmbeddedExpressions(List<AngularMoustacheXmlExpression> list, Token token) {
        String string = token.getLexeme();
        int n = token.getOffset();
        int n2 = StringUtilities.indexOf2(string, 0, 123, 123);
        while (n2 >= 0) {
            int n3 = StringUtilities.indexOf2(string, n2 + AngularMoustacheXmlExpression.OPENING_DELIMITER_LENGTH, 125, 125);
            if (n3 < 0) {
                return;
            }
            if (n2 + AngularMoustacheXmlExpression.OPENING_DELIMITER_LENGTH < n3) {
                AngularExpression angularExpression = this.parseAngularExpression(string, n2 += AngularMoustacheXmlExpression.OPENING_DELIMITER_LENGTH, n3, n);
                list.add(new AngularMoustacheXmlExpression(n2, n3, angularExpression));
            }
            n2 = StringUtilities.indexOf2(string, n3 + AngularMoustacheXmlExpression.CLOSING_DELIMITER_LENGTH, 123, 123);
        }
    }

    private void parseEmbeddedExpressionsInAttribute(XmlAttributeNode xmlAttributeNode) {
        ArrayList<AngularMoustacheXmlExpression> arrayList = Lists.newArrayList();
        this.parseEmbeddedExpressions(arrayList, xmlAttributeNode.getValueToken());
        if (!arrayList.isEmpty()) {
            xmlAttributeNode.setExpressions(arrayList.toArray(new AngularMoustacheXmlExpression[arrayList.size()]));
        }
    }

    private void parseEmbeddedExpressionsInTag(XmlTagNode xmlTagNode) {
        ArrayList<AngularMoustacheXmlExpression> arrayList = Lists.newArrayList();
        Token token = xmlTagNode.getEndToken();
        boolean bl = false;
        for (Token token2 = xmlTagNode.getAttributeEnd(); token2 != token; token2 = token2.getNext()) {
            for (XmlTagNode xmlTagNode2 : xmlTagNode.getTagNodes()) {
                if (token2 == xmlTagNode2.getBeginToken()) {
                    bl = true;
                    break;
                }
                if (token2 != xmlTagNode2.getEndToken()) continue;
                bl = false;
                break;
            }
            if (bl || token2.getType() != com.google.dart.engine.html.scanner.TokenType.TEXT) continue;
            this.parseEmbeddedExpressions(arrayList, token2);
        }
        xmlTagNode.setExpressions(arrayList.toArray(new AngularMoustacheXmlExpression[arrayList.size()]));
    }

    private void recordDefinedVariable(LocalVariableElementImpl localVariableElementImpl) {
        this.definedVariables.add(localVariableElementImpl);
        this.functionElement.setLocalVariables(this.definedVariables.toArray(new LocalVariableElementImpl[this.definedVariables.size()]));
    }

    private void recordTypeLibraryInjected(LocalVariableElementImpl localVariableElementImpl) {
        LibraryElement libraryElement = localVariableElementImpl.getType().getElement().getLibrary();
        this.injectedLibraries.add(libraryElement);
    }

    private void resolveExpressions(XmlExpression[] xmlExpressionArray) {
        for (XmlExpression xmlExpression : xmlExpressionArray) {
            if (!(xmlExpression instanceof AngularXmlExpression)) continue;
            AngularXmlExpression angularXmlExpression = (AngularXmlExpression)xmlExpression;
            this.resolveXmlExpression(angularXmlExpression);
        }
    }

    private void resolveInternal(AngularElement[] angularElementArray, AngularComponentElement angularComponentElement) throws AnalysisException {
        this.angularElements = angularElementArray;
        this.processors.add(NgModelProcessor.INSTANCE);
        this.processors.add(NgRepeatProcessor.INSTANCE);
        for (AngularElement angularElement : angularElementArray) {
            this.injectedLibraries.add(angularElement.getLibrary());
        }
        this.createLibraryElement();
        ((HtmlElementImpl)this.unit.getElement()).setAngularCompilationUnit(this.unitElement);
        this.createResolver();
        if (angularComponentElement != null) {
            this.defineTopVariable_forClassElement(angularComponentElement);
            for (AngularElement angularElement : angularComponentElement.getScopeProperties()) {
                this.defineTopVariable_forScopeProperty((AngularScopePropertyElement)angularElement);
            }
        }
        for (AngularElement angularElement : angularElementArray) {
            NgProcessor ngProcessor = this.createProcessor(angularElement);
            if (ngProcessor == null) continue;
            this.processors.add(ngProcessor);
        }
        for (AngularElement angularElement : angularElementArray) {
            if (!(angularElement instanceof AngularFilterElement)) continue;
            this.defineTopVariable_forClassElement(angularElement);
        }
        this.unit.accept(this);
        ArrayList arrayList = Lists.newArrayList();
        for (LibraryElement libraryElement : this.injectedLibraries) {
            ImportElementImpl importElementImpl = new ImportElementImpl(-1);
            importElementImpl.setImportedLibrary(libraryElement);
            arrayList.add(importElementImpl);
        }
        this.libraryElement.setImports(arrayList.toArray(new ImportElement[arrayList.size()]));
        for (ProxyConditionalAnalysisError proxyConditionalAnalysisError : this.resolver.getProxyConditionalAnalysisErrors()) {
            this.resolver.reportError(proxyConditionalAnalysisError.getAnalysisError());
        }
    }

    private void resolveXmlExpression(AngularXmlExpression angularXmlExpression) {
        AngularExpression angularExpression = angularXmlExpression.getExpression();
        this.resolveExpression(angularExpression);
    }

    private List<com.google.dart.engine.scanner.Token> splitAtBar(com.google.dart.engine.scanner.Token token) {
        ArrayList<com.google.dart.engine.scanner.Token> arrayList = Lists.newArrayList();
        arrayList.add(token);
        while (token.getType() != TokenType.EOF) {
            if (token.getType() == TokenType.BAR) {
                arrayList.add(token);
                com.google.dart.engine.scanner.Token token2 = new com.google.dart.engine.scanner.Token(TokenType.EOF, 0);
                token.getPrevious().setNext(token2);
            }
            token = token.getNext();
        }
        return arrayList;
    }

    private void visitModelDirectives(XmlTagNode xmlTagNode) {
        xmlTagNode.accept(new RecursiveXmlVisitor<Void>(){

            @Override
            public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
                NgModelProcessor ngModelProcessor = NgModelProcessor.INSTANCE;
                if (ngModelProcessor.canApply(xmlTagNode)) {
                    ngModelProcessor.applyTopDeclarations(AngularHtmlUnitResolver.this, xmlTagNode);
                }
                return (Void)super.visitXmlTagNode(xmlTagNode);
            }
        });
    }

    private static class FoundAppError
    extends Error {
        private FoundAppError() {
        }
    }

    private static class FilteringAnalysisErrorListener
    implements AnalysisErrorListener {
        private final AnalysisErrorListener listener;

        public FilteringAnalysisErrorListener(AnalysisErrorListener analysisErrorListener) {
            this.listener = analysisErrorListener;
        }

        @Override
        public void onError(AnalysisError analysisError) {
            ErrorCode errorCode = analysisError.getErrorCode();
            if (errorCode == StaticWarningCode.UNDEFINED_GETTER || errorCode == StaticWarningCode.UNDEFINED_IDENTIFIER || errorCode == StaticTypeWarningCode.UNDEFINED_GETTER) {
                return;
            }
            this.listener.onError(analysisError);
        }
    }
}

