/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.index.Relationship;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.ExpressionVisitor;
import com.google.dart.engine.internal.index.IndexConstants;
import com.google.dart.engine.internal.index.IndexContributor;

public class AngularHtmlIndexContributor
extends ExpressionVisitor {
    private final IndexStore store;
    private final IndexContributor indexContributor;
    private HtmlElement htmlUnitElement;

    public AngularHtmlIndexContributor(IndexStore indexStore) {
        this.store = indexStore;
        this.indexContributor = new IndexContributor(indexStore){

            @Override
            public Element peekElement() {
                return AngularHtmlIndexContributor.this.htmlUnitElement;
            }

            @Override
            protected void recordRelationship(Element element, Relationship relationship, Location location) {
                AngularElement angularElement = AngularHtmlUnitResolver.getAngularElement(element);
                if (angularElement != null) {
                    element = angularElement;
                    relationship = IndexConstants.ANGULAR_REFERENCE;
                }
                super.recordRelationship(element, relationship, location);
            }
        };
    }

    @Override
    public void visitExpression(Expression expression) {
        SimpleIdentifier simpleIdentifier;
        Element element;
        if (expression instanceof SimpleIdentifier && (element = (simpleIdentifier = (SimpleIdentifier)expression).getBestElement()) instanceof AngularElement) {
            this.store.recordRelationship(element, IndexConstants.ANGULAR_REFERENCE, this.createLocationForIdentifier(simpleIdentifier));
            return;
        }
        expression.accept(this.indexContributor);
    }

    @Override
    public Void visitHtmlUnit(HtmlUnit htmlUnit) {
        this.htmlUnitElement = htmlUnit.getElement();
        CompilationUnitElement compilationUnitElement = this.htmlUnitElement.getAngularCompilationUnit();
        this.indexContributor.enterScope(compilationUnitElement);
        return (Void)super.visitHtmlUnit(htmlUnit);
    }

    @Override
    public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
        Element element = xmlAttributeNode.getElement();
        if (element != null) {
            Token token = xmlAttributeNode.getNameToken();
            Location location = this.createLocationForToken(token);
            this.store.recordRelationship(element, IndexConstants.ANGULAR_REFERENCE, location);
        }
        return super.visitXmlAttributeNode(xmlAttributeNode);
    }

    @Override
    public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
        Element element = xmlTagNode.getElement();
        if (element != null) {
            Token token = xmlTagNode.getTagToken();
            Location location = this.createLocationForToken(token);
            this.store.recordRelationship(element, IndexConstants.ANGULAR_REFERENCE, location);
            token = xmlTagNode.getClosingTag();
            if (token != null) {
                location = this.createLocationForToken(token);
                this.store.recordRelationship(element, IndexConstants.ANGULAR_CLOSING_TAG_REFERENCE, location);
            }
        }
        return super.visitXmlTagNode(xmlTagNode);
    }

    private Location createLocationForIdentifier(SimpleIdentifier simpleIdentifier) {
        return new Location(this.htmlUnitElement, simpleIdentifier.getOffset(), simpleIdentifier.getLength());
    }

    private Location createLocationForToken(Token token) {
        return new Location(this.htmlUnitElement, token.getOffset(), token.getLength());
    }
}

