/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.common.collect.Lists;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.internal.html.angular.AngularFilterArgument;
import com.google.dart.engine.internal.html.angular.AngularFilterNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AngularExpression {
    private final Expression expression;
    private final List<AngularFilterNode> filters;

    public AngularExpression(Expression expression, List<AngularFilterNode> list) {
        this.expression = expression;
        this.filters = list;
    }

    public int getEnd() {
        if (this.filters.isEmpty()) {
            return this.expression.getEnd();
        }
        AngularFilterNode angularFilterNode = this.filters.get(this.filters.size() - 1);
        List<AngularFilterArgument> list = angularFilterNode.getArguments();
        if (list.isEmpty()) {
            return angularFilterNode.getName().getEnd();
        }
        return list.get(list.size() - 1).getExpression().getEnd();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getExpressions() {
        ArrayList<Expression> arrayList = Lists.newArrayList();
        arrayList.add(this.expression);
        for (AngularFilterNode angularFilterNode : this.filters) {
            arrayList.add(angularFilterNode.getName());
            for (AngularFilterArgument angularFilterArgument : angularFilterNode.getArguments()) {
                Collections.addAll(arrayList, angularFilterArgument.getSubExpressions());
                arrayList.add(angularFilterArgument.getExpression());
            }
        }
        return arrayList;
    }

    public List<AngularFilterNode> getFilters() {
        return this.filters;
    }

    public int getLength() {
        return this.getEnd() - this.getOffset();
    }

    public int getOffset() {
        return this.expression.getOffset();
    }
}

