/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html.angular;

import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularDirectiveElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.index.IndexStore;
import com.google.dart.engine.index.Location;
import com.google.dart.engine.internal.index.IndexConstants;

public class AngularDartIndexContributor
extends GeneralizingAstVisitor<Void> {
    private final IndexStore store;

    public AngularDartIndexContributor(IndexStore indexStore) {
        this.store = indexStore;
    }

    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = classDeclaration.getElement();
        if (classElement != null) {
            ToolkitObjectElement[] toolkitObjectElementArray;
            for (ToolkitObjectElement toolkitObjectElement : toolkitObjectElementArray = classElement.getToolkitObjects()) {
                if (toolkitObjectElement instanceof AngularComponentElement) {
                    this.indexComponent((AngularComponentElement)toolkitObjectElement);
                }
                if (!(toolkitObjectElement instanceof AngularDirectiveElement)) continue;
                AngularDirectiveElement angularDirectiveElement = (AngularDirectiveElement)toolkitObjectElement;
                this.indexDirective(angularDirectiveElement);
            }
        }
        return null;
    }

    @Override
    public Void visitCompilationUnitMember(CompilationUnitMember compilationUnitMember) {
        return null;
    }

    private void indexComponent(AngularComponentElement angularComponentElement) {
        this.indexProperties(angularComponentElement.getProperties());
    }

    private void indexDirective(AngularDirectiveElement angularDirectiveElement) {
        this.indexProperties(angularDirectiveElement.getProperties());
    }

    private void indexProperties(AngularPropertyElement[] angularPropertyElementArray) {
        for (AngularPropertyElement angularPropertyElement : angularPropertyElementArray) {
            PropertyAccessorElement propertyAccessorElement;
            int n;
            FieldElement fieldElement = angularPropertyElement.getField();
            if (fieldElement == null || (n = angularPropertyElement.getFieldNameOffset()) == -1) continue;
            int n2 = fieldElement.getName().length();
            Location location = new Location(angularPropertyElement, n, n2);
            if (angularPropertyElement.getPropertyKind().callsGetter() && (propertyAccessorElement = fieldElement.getGetter()) != null) {
                this.store.recordRelationship(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, location);
            }
            if (!angularPropertyElement.getPropertyKind().callsSetter() || (propertyAccessorElement = fieldElement.getSetter()) == null) continue;
            this.store.recordRelationship(propertyAccessorElement, IndexConstants.IS_REFERENCED_BY_QUALIFIED, location);
        }
    }
}

