/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.html;

import com.google.dart.engine.html.ast.HtmlScriptTagNode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.internal.html.HtmlTagInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HtmlTagInfoBuilder
implements XmlVisitor<Void> {
    private static final String ID_ATTRIBUTE = "id";
    private static final String ID_CLASS = "class";
    private HashSet<String> tagSet = new HashSet();
    private HashMap<String, String> idMap = new HashMap();
    private HashMap<String, HashSet<String>> classMap = new HashMap();

    public HtmlTagInfo getTagInfo() {
        String[] stringArray = this.tagSet.toArray(new String[this.tagSet.size()]);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(this.idMap.size());
        for (Map.Entry<String, HashSet<String>> entry : this.classMap.entrySet()) {
            HashSet<String> hashSet = entry.getValue();
            hashMap.put(entry.getKey(), hashSet.toArray(new String[hashSet.size()]));
        }
        return new HtmlTagInfo(stringArray, this.idMap, hashMap);
    }

    @Override
    public Void visitHtmlScriptTagNode(HtmlScriptTagNode htmlScriptTagNode) {
        return this.visitXmlTagNode(htmlScriptTagNode);
    }

    @Override
    public Void visitHtmlUnit(HtmlUnit htmlUnit) {
        htmlUnit.visitChildren(this);
        return null;
    }

    @Override
    public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
        return null;
    }

    @Override
    public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
        xmlTagNode.visitChildren(this);
        String string = xmlTagNode.getTag();
        this.tagSet.add(string);
        for (XmlAttributeNode xmlAttributeNode : xmlTagNode.getAttributes()) {
            HashSet<String> hashSet;
            String string2;
            String string3 = xmlAttributeNode.getName();
            if (string3.equals(ID_ATTRIBUTE)) {
                string2 = xmlAttributeNode.getText();
                if (string2 == null || (hashSet = this.idMap.get(string2)) != null) continue;
                this.idMap.put(string2, string);
                continue;
            }
            if (!string3.equals(ID_CLASS) || (string2 = xmlAttributeNode.getText()) == null) continue;
            hashSet = this.classMap.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.classMap.put(string2, hashSet);
            }
            hashSet.add(string);
        }
        return null;
    }
}

