/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.error.TodoCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import java.util.regex.Matcher;

public class ToDoFinder {
    private ErrorReporter errorReporter;

    public ToDoFinder(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void findIn(CompilationUnit compilationUnit) {
        this.gatherTodoComments(compilationUnit.getBeginToken());
    }

    private void gatherTodoComments(Token token) {
        while (token != null && token.getType() != TokenType.EOF) {
            for (Token token2 = token.getPrecedingComments(); token2 != null; token2 = token2.getNext()) {
                if (token2.getType() != TokenType.SINGLE_LINE_COMMENT && token2.getType() != TokenType.MULTI_LINE_COMMENT) continue;
                this.scrapeTodoComment(token2);
            }
            token = token.getNext();
        }
    }

    private void scrapeTodoComment(Token token) {
        Matcher matcher = TodoCode.TODO_REGEX.matcher(token.getLexeme());
        if (matcher.find()) {
            int n = token.getOffset() + matcher.start() + matcher.group(1).length();
            int n2 = matcher.group(2).length();
            this.errorReporter.reportErrorForOffset(TodoCode.TODO, n, n2, matcher.group(2));
        }
    }
}

