/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.error.PubSuggestionCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.io.File;

public class PubVerifier
extends RecursiveAstVisitor<Void> {
    private static final String PUBSPEC_YAML = "pubspec.yaml";
    private final AnalysisContext context;
    private final ErrorReporter errorReporter;

    public PubVerifier(AnalysisContext analysisContext, ErrorReporter errorReporter) {
        this.context = analysisContext;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        String string;
        String string2;
        StringLiteral stringLiteral = importDirective.getUri();
        if (stringLiteral == null) {
            return null;
        }
        String string3 = stringLiteral.getStringValue();
        if (string3 == null) {
            return null;
        }
        int n = (string3 = string3.trim()).indexOf(58);
        if (n > -1) {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        } else {
            string2 = "file";
            string = string3;
        }
        if (string2.equals("file")) {
            if (!this.checkForFileImportOutsideLibReferencesFileInside(stringLiteral, string)) {
                this.checkForFileImportInsideLibReferencesFileOutside(stringLiteral, string);
            }
        } else if (string2.equals("package")) {
            this.checkForPackageImportContainsDotDot(stringLiteral, string);
        }
        return null;
    }

    private boolean checkForFileImportInsideLibReferencesFileOutside(StringLiteral stringLiteral, String string) {
        Source source = this.getSource(stringLiteral);
        String string2 = this.getSourceFullName(source);
        if (string2 != null) {
            int n = string2.length();
            for (int i = 0; i < string.length() && StringUtilities.startsWith3(string, i, 46, 46, 47); i += 3) {
                if ((n = string2.lastIndexOf(47, n)) < 4) {
                    return false;
                }
                if (!StringUtilities.startsWith4(string2, n - 4, 47, 108, 105, 98)) continue;
                String string3 = string.substring(0, i + 3).concat(PUBSPEC_YAML);
                Source source2 = this.context.getSourceFactory().resolveUri(source, string3);
                if (this.context.exists(source2)) {
                    this.errorReporter.reportErrorForNode(PubSuggestionCode.FILE_IMPORT_INSIDE_LIB_REFERENCES_FILE_OUTSIDE, stringLiteral, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkForFileImportOutsideLibReferencesFileInside(StringLiteral stringLiteral, String string) {
        if (StringUtilities.startsWith4(string, 0, 108, 105, 98, 47) && this.checkForFileImportOutsideLibReferencesFileInsideAtIndex(stringLiteral, string, 0)) {
            return true;
        }
        int n = StringUtilities.indexOf5(string, 0, 47, 108, 105, 98, 47);
        while (n != -1) {
            if (this.checkForFileImportOutsideLibReferencesFileInsideAtIndex(stringLiteral, string, n + 1)) {
                return true;
            }
            n = StringUtilities.indexOf5(string, n + 4, 47, 108, 105, 98, 47);
        }
        return false;
    }

    private boolean checkForFileImportOutsideLibReferencesFileInsideAtIndex(StringLiteral stringLiteral, String string, int n) {
        Source source = this.getSource(stringLiteral);
        String string2 = string.substring(0, n).concat(PUBSPEC_YAML);
        Source source2 = this.context.getSourceFactory().resolveUri(source, string2);
        if (!this.context.exists(source2)) {
            return false;
        }
        String string3 = this.getSourceFullName(source);
        if (string3 != null && StringUtilities.indexOf5(string3, 0, 47, 108, 105, 98, 47) < 0) {
            this.errorReporter.reportErrorForNode(PubSuggestionCode.FILE_IMPORT_OUTSIDE_LIB_REFERENCES_FILE_INSIDE, stringLiteral, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForPackageImportContainsDotDot(StringLiteral stringLiteral, String string) {
        if (StringUtilities.startsWith3(string, 0, 46, 46, 47) || StringUtilities.indexOf4(string, 0, 47, 46, 46, 47) >= 0) {
            this.errorReporter.reportErrorForNode(PubSuggestionCode.PACKAGE_IMPORT_CONTAINS_DOT_DOT, stringLiteral, new Object[0]);
            return true;
        }
        return false;
    }

    private Source getSource(AstNode astNode) {
        CompilationUnitElement compilationUnitElement;
        Source source = null;
        CompilationUnit compilationUnit = astNode.getAncestor(CompilationUnit.class);
        if (compilationUnit != null && (compilationUnitElement = compilationUnit.getElement()) != null) {
            source = compilationUnitElement.getSource();
        }
        return source;
    }

    private String getSourceFullName(Source source) {
        String string;
        if (source != null && (string = source.getFullName()) != null) {
            return string.replace(File.separatorChar, '/');
        }
        return null;
    }
}

