/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.resolver.InheritanceManager;

public class OverrideVerifier
extends RecursiveAstVisitor<Void> {
    private InheritanceManager manager;
    private ErrorReporter errorReporter;

    public OverrideVerifier(InheritanceManager inheritanceManager, ErrorReporter errorReporter) {
        this.manager = inheritanceManager;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ExecutableElement executableElement = methodDeclaration.getElement();
        if (this.isOverride(executableElement) && this.getOverriddenMember(executableElement) == null) {
            if (executableElement instanceof MethodElement) {
                this.errorReporter.reportErrorForNode(HintCode.OVERRIDE_ON_NON_OVERRIDING_METHOD, methodDeclaration.getName(), new Object[0]);
            } else if (executableElement instanceof PropertyAccessorElement) {
                if (((PropertyAccessorElement)executableElement).isGetter()) {
                    this.errorReporter.reportErrorForNode(HintCode.OVERRIDE_ON_NON_OVERRIDING_GETTER, methodDeclaration.getName(), new Object[0]);
                } else {
                    this.errorReporter.reportErrorForNode(HintCode.OVERRIDE_ON_NON_OVERRIDING_SETTER, methodDeclaration.getName(), new Object[0]);
                }
            }
        }
        return (Void)super.visitMethodDeclaration(methodDeclaration);
    }

    private ExecutableElement getOverriddenMember(ExecutableElement executableElement) {
        LibraryElement libraryElement = executableElement.getLibrary();
        if (libraryElement == null) {
            return null;
        }
        ClassElement classElement = executableElement.getAncestor(ClassElement.class);
        if (classElement == null) {
            return null;
        }
        return this.manager.lookupInheritance(classElement, executableElement.getName());
    }

    private boolean isOverride(Element element) {
        return element != null && element.isOverride();
    }
}

