/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MultiplyDefinedElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ImportsVerifier
extends RecursiveAstVisitor<Void> {
    private boolean inDefiningCompilationUnit = false;
    private final LibraryElement currentLibrary;
    private final ArrayList<ImportDirective> unusedImports;
    private final ArrayList<ImportDirective> duplicateImports;
    private final HashMap<LibraryElement, ArrayList<ImportDirective>> libraryMap;
    private final HashMap<ImportDirective, Namespace> namespaceMap;
    private final HashMap<PrefixElement, ImportDirective> prefixElementMap;

    public ImportsVerifier(LibraryElement libraryElement) {
        this.currentLibrary = libraryElement;
        this.unusedImports = new ArrayList();
        this.duplicateImports = new ArrayList();
        this.libraryMap = new HashMap();
        this.namespaceMap = new HashMap();
        this.prefixElementMap = new HashMap();
    }

    public void generateDuplicateImportHints(ErrorReporter errorReporter) {
        for (ImportDirective importDirective : this.duplicateImports) {
            errorReporter.reportErrorForNode(HintCode.DUPLICATE_IMPORT, importDirective.getUri(), new Object[0]);
        }
    }

    public void generateUnusedImportHints(ErrorReporter errorReporter) {
        for (ImportDirective importDirective : this.unusedImports) {
            LibraryElement libraryElement;
            ImportElement importElement = importDirective.getElement();
            if (importElement != null && (libraryElement = importElement.getImportedLibrary()) != null && libraryElement.isDartCore()) continue;
            errorReporter.reportErrorForNode(HintCode.UNUSED_IMPORT, importDirective.getUri(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCompilationUnit(CompilationUnit compilationUnit) {
        ImportDirective importDirective;
        ImportDirective[] importDirectiveArray;
        if (this.inDefiningCompilationUnit) {
            importDirectiveArray = compilationUnit.getDirectives();
            for (Directive directive : importDirectiveArray) {
                Element element;
                SimpleIdentifier simpleIdentifier;
                LibraryElement libraryElement;
                if (!(directive instanceof ImportDirective) || (libraryElement = (importDirective = (ImportDirective)directive).getUriElement()) == null) continue;
                this.unusedImports.add(importDirective);
                if (importDirective.getAsToken() != null && (simpleIdentifier = importDirective.getPrefix()) != null && (element = simpleIdentifier.getStaticElement()) instanceof PrefixElement) {
                    PrefixElement prefixElement = (PrefixElement)element;
                    this.prefixElementMap.put(prefixElement, importDirective);
                }
                this.putIntoLibraryMap(libraryElement, importDirective);
                this.addAdditionalLibrariesForExports(libraryElement, importDirective, new ArrayList<LibraryElement>());
            }
        }
        if (this.unusedImports.isEmpty()) {
            return null;
        }
        if (this.unusedImports.size() > 1) {
            void var4_6;
            importDirectiveArray = this.unusedImports.toArray(new ImportDirective[this.unusedImports.size()]);
            Arrays.sort(importDirectiveArray, ImportDirective.COMPARATOR);
            Object object = importDirectiveArray[0];
            boolean i = true;
            while (var4_6 < importDirectiveArray.length) {
                importDirective = importDirectiveArray[var4_6];
                if (ImportDirective.COMPARATOR.compare((ImportDirective)object, importDirective) == 0) {
                    if (((AstNode)object).getOffset() < importDirective.getOffset()) {
                        this.duplicateImports.add(importDirective);
                    } else {
                        this.duplicateImports.add((ImportDirective)object);
                    }
                }
                object = importDirective;
                ++var4_6;
            }
        }
        return (Void)super.visitCompilationUnit(compilationUnit);
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        this.visitMetadata(exportDirective.getMetadata());
        return null;
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        this.visitMetadata(importDirective.getMetadata());
        return null;
    }

    @Override
    public Void visitLibraryDirective(LibraryDirective libraryDirective) {
        this.visitMetadata(libraryDirective.getMetadata());
        return null;
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        if (this.unusedImports.isEmpty()) {
            return null;
        }
        SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
        Element element = simpleIdentifier.getStaticElement();
        if (element instanceof PrefixElement) {
            this.unusedImports.remove(this.prefixElementMap.get(element));
            return null;
        }
        return this.visitIdentifier(element, simpleIdentifier.getName());
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        if (this.unusedImports.isEmpty()) {
            return null;
        }
        return this.visitIdentifier(simpleIdentifier.getStaticElement(), simpleIdentifier.getName());
    }

    void setInDefiningCompilationUnit(boolean bl) {
        this.inDefiningCompilationUnit = bl;
    }

    private void addAdditionalLibrariesForExports(LibraryElement libraryElement, ImportDirective importDirective, ArrayList<LibraryElement> arrayList) {
        if (arrayList.contains(libraryElement)) {
            return;
        }
        arrayList.add(libraryElement);
        for (LibraryElement libraryElement2 : libraryElement.getExportedLibraries()) {
            this.putIntoLibraryMap(libraryElement2, importDirective);
            this.addAdditionalLibrariesForExports(libraryElement2, importDirective, arrayList);
        }
    }

    private Namespace computeNamespace(ImportDirective importDirective) {
        ImportElement importElement;
        Namespace namespace = this.namespaceMap.get(importDirective);
        if (namespace == null && (importElement = importDirective.getElement()) != null) {
            NamespaceBuilder namespaceBuilder = new NamespaceBuilder();
            namespace = namespaceBuilder.createImportNamespaceForDirective(importElement);
            this.namespaceMap.put(importDirective, namespace);
        }
        return namespace;
    }

    private void putIntoLibraryMap(LibraryElement libraryElement, ImportDirective importDirective) {
        ArrayList<ImportDirective> arrayList = this.libraryMap.get(libraryElement);
        if (arrayList == null) {
            arrayList = new ArrayList(3);
            this.libraryMap.put(libraryElement, arrayList);
        }
        arrayList.add(importDirective);
    }

    private Void visitIdentifier(Element element, String string) {
        if (element == null) {
            return null;
        }
        if (element instanceof MultiplyDefinedElement) {
            MultiplyDefinedElement multiplyDefinedElement = (MultiplyDefinedElement)element;
            for (Element element2 : multiplyDefinedElement.getConflictingElements()) {
                this.visitIdentifier(element2, string);
            }
            return null;
        }
        if (element instanceof PrefixElement) {
            this.unusedImports.remove(this.prefixElementMap.get(element));
            return null;
        }
        if (!(element.getEnclosingElement() instanceof CompilationUnitElement)) {
            return null;
        }
        LibraryElement libraryElement = element.getLibrary();
        if (libraryElement == null) {
            return null;
        }
        if (this.currentLibrary.equals(libraryElement)) {
            return null;
        }
        ArrayList<ImportDirective> arrayList = this.libraryMap.get(libraryElement);
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 1) {
            ImportDirective importDirective = arrayList.get(0);
            this.unusedImports.remove(importDirective);
        } else {
            for (ImportDirective importDirective : arrayList) {
                Namespace namespace = this.computeNamespace(importDirective);
                if (namespace == null || namespace.get(string) == null) continue;
                this.unusedImports.remove(importDirective);
            }
        }
        return null;
    }

    private void visitMetadata(NodeList<Annotation> nodeList) {
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            ((Annotation)nodeList.get(i)).accept(this);
        }
    }
}

