/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.hint.BestPracticesVerifier;
import com.google.dart.engine.internal.hint.Dart2JSVerifier;
import com.google.dart.engine.internal.hint.DeadCodeVerifier;
import com.google.dart.engine.internal.hint.ImportsVerifier;
import com.google.dart.engine.internal.hint.OverrideVerifier;
import com.google.dart.engine.internal.hint.ToDoFinder;
import com.google.dart.engine.internal.resolver.InheritanceManager;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;

public class HintGenerator {
    private final CompilationUnit[] compilationUnits;
    private final AnalysisContext context;
    AnalysisErrorListener errorListener;
    private ImportsVerifier importsVerifier;
    private final boolean enableDart2JSHints;
    private InheritanceManager manager;

    public HintGenerator(CompilationUnit[] compilationUnitArray, AnalysisContext analysisContext, AnalysisErrorListener analysisErrorListener) {
        this.compilationUnits = compilationUnitArray;
        this.context = analysisContext;
        this.errorListener = analysisErrorListener;
        LibraryElement libraryElement = compilationUnitArray[0].getElement().getLibrary();
        this.importsVerifier = new ImportsVerifier(libraryElement);
        this.enableDart2JSHints = analysisContext.getAnalysisOptions().getDart2jsHint();
        this.manager = new InheritanceManager(compilationUnitArray[0].getElement().getLibrary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateForLibrary() throws AnalysisException {
        TimeCounter.TimeCounterHandle timeCounterHandle = PerformanceStatistics.hints.start();
        try {
            for (int i = 0; i < this.compilationUnits.length; ++i) {
                CompilationUnitElement compilationUnitElement = this.compilationUnits[i].getElement();
                if (compilationUnitElement == null) continue;
                if (i == 0) {
                    this.importsVerifier.setInDefiningCompilationUnit(true);
                    this.generateForCompilationUnit(this.compilationUnits[i], compilationUnitElement.getSource());
                    this.importsVerifier.setInDefiningCompilationUnit(false);
                    continue;
                }
                this.generateForCompilationUnit(this.compilationUnits[i], compilationUnitElement.getSource());
            }
            ErrorReporter errorReporter = new ErrorReporter(this.errorListener, this.compilationUnits[0].getElement().getSource());
            this.importsVerifier.generateDuplicateImportHints(errorReporter);
            this.importsVerifier.generateUnusedImportHints(errorReporter);
        }
        finally {
            timeCounterHandle.stop();
        }
    }

    private void generateForCompilationUnit(CompilationUnit compilationUnit, Source source) {
        ErrorReporter errorReporter = new ErrorReporter(this.errorListener, source);
        compilationUnit.accept(this.importsVerifier);
        compilationUnit.accept(new DeadCodeVerifier(errorReporter));
        if (this.enableDart2JSHints) {
            compilationUnit.accept(new Dart2JSVerifier(errorReporter));
        }
        compilationUnit.accept(new BestPracticesVerifier(errorReporter));
        compilationUnit.accept(new OverrideVerifier(this.manager, errorReporter));
        new ToDoFinder(errorReporter).findIn(compilationUnit);
    }
}

