/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.EmptyStatement;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.Literal;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.scanner.TokenType;

public class ExitDetector
extends GeneralizingAstVisitor<Boolean> {
    private boolean enclosingBlockContainsBreak = false;

    @Override
    public Boolean visitArgumentList(ArgumentList argumentList) {
        return this.visitExpressions(argumentList.getArguments());
    }

    @Override
    public Boolean visitAsExpression(AsExpression asExpression) {
        return asExpression.getExpression().accept(this);
    }

    @Override
    public Boolean visitAssertStatement(AssertStatement assertStatement) {
        return assertStatement.getCondition().accept(this);
    }

    @Override
    public Boolean visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        return assignmentExpression.getLeftHandSide().accept(this) != false || assignmentExpression.getRightHandSide().accept(this) != false;
    }

    @Override
    public Boolean visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression expression;
        Expression expression2 = binaryExpression.getLeftOperand();
        TokenType tokenType = binaryExpression.getOperator().getType();
        if (tokenType == TokenType.BAR_BAR && expression2 instanceof BooleanLiteral && !((BooleanLiteral)(expression = (BooleanLiteral)expression2)).getValue()) {
            return false;
        }
        if (tokenType == TokenType.AMPERSAND_AMPERSAND && expression2 instanceof BooleanLiteral && ((BooleanLiteral)(expression = (BooleanLiteral)expression2)).getValue()) {
            return false;
        }
        expression = binaryExpression.getRightOperand();
        return expression2 != null && expression2.accept(this) != false || expression != null && expression.accept(this) != false;
    }

    @Override
    public Boolean visitBlock(Block block) {
        return this.visitStatements(block.getStatements());
    }

    @Override
    public Boolean visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        return blockFunctionBody.getBlock().accept(this);
    }

    @Override
    public Boolean visitBreakStatement(BreakStatement breakStatement) {
        this.enclosingBlockContainsBreak = true;
        return false;
    }

    @Override
    public Boolean visitCascadeExpression(CascadeExpression cascadeExpression) {
        Expression expression = cascadeExpression.getTarget();
        if (expression.accept(this).booleanValue()) {
            return true;
        }
        return this.visitExpressions(cascadeExpression.getCascadeSections());
    }

    @Override
    public Boolean visitConditionalExpression(ConditionalExpression conditionalExpression) {
        Expression expression = conditionalExpression.getCondition();
        Expression expression2 = conditionalExpression.getThenExpression();
        Expression expression3 = conditionalExpression.getElseExpression();
        if (expression.accept(this).booleanValue()) {
            return true;
        }
        if (expression2 == null || expression3 == null) {
            return false;
        }
        return expression2.accept(this) != false && expression3.accept(this) != false;
    }

    @Override
    public Boolean visitContinueStatement(ContinueStatement continueStatement) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitDoStatement(DoStatement doStatement) {
        boolean bl = this.enclosingBlockContainsBreak;
        this.enclosingBlockContainsBreak = false;
        try {
            Object object;
            Expression expression = doStatement.getCondition();
            if (expression.accept(this).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
            if (expression instanceof BooleanLiteral) {
                object = (BooleanLiteral)expression;
                boolean bl3 = doStatement.getBody().accept(this);
                if (((BooleanLiteral)object).getValue() && (bl3 || !this.enclosingBlockContainsBreak)) {
                    Boolean bl4 = true;
                    return bl4;
                }
            }
            object = false;
            return object;
        }
        finally {
            this.enclosingBlockContainsBreak = bl;
        }
    }

    @Override
    public Boolean visitEmptyStatement(EmptyStatement emptyStatement) {
        return false;
    }

    @Override
    public Boolean visitExpressionStatement(ExpressionStatement expressionStatement) {
        return expressionStatement.getExpression().accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitForEachStatement(ForEachStatement forEachStatement) {
        boolean bl = this.enclosingBlockContainsBreak;
        this.enclosingBlockContainsBreak = false;
        try {
            Boolean bl2 = forEachStatement.getIterator().accept(this);
            return bl2;
        }
        finally {
            this.enclosingBlockContainsBreak = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitForStatement(ForStatement forStatement) {
        boolean bl = this.enclosingBlockContainsBreak;
        this.enclosingBlockContainsBreak = false;
        try {
            boolean bl2;
            boolean bl3;
            if (forStatement.getVariables() != null && this.visitVariableDeclarations(forStatement.getVariables().getVariables())) {
                Boolean bl4 = true;
                return bl4;
            }
            if (forStatement.getInitialization() != null && forStatement.getInitialization().accept(this).booleanValue()) {
                Boolean bl5 = true;
                return bl5;
            }
            Expression expression = forStatement.getCondition();
            if (expression != null && expression.accept(this).booleanValue()) {
                Boolean bl6 = true;
                return bl6;
            }
            if (this.visitExpressions(forStatement.getUpdaters())) {
                Boolean bl7 = true;
                return bl7;
            }
            boolean bl8 = bl3 = expression == null || expression instanceof BooleanLiteral && ((BooleanLiteral)expression).getValue();
            if (bl3 && ((bl2 = forStatement.getBody().accept(this).booleanValue()) || !this.enclosingBlockContainsBreak)) {
                Boolean bl9 = true;
                return bl9;
            }
            Boolean bl10 = false;
            return bl10;
        }
        finally {
            this.enclosingBlockContainsBreak = bl;
        }
    }

    @Override
    public Boolean visitFunctionDeclarationStatement(FunctionDeclarationStatement functionDeclarationStatement) {
        return false;
    }

    @Override
    public Boolean visitFunctionExpression(FunctionExpression functionExpression) {
        return false;
    }

    @Override
    public Boolean visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        if (functionExpressionInvocation.getFunction().accept(this).booleanValue()) {
            return true;
        }
        return functionExpressionInvocation.getArgumentList().accept(this);
    }

    @Override
    public Boolean visitIdentifier(Identifier identifier) {
        return false;
    }

    @Override
    public Boolean visitIfStatement(IfStatement ifStatement) {
        Expression expression = ifStatement.getCondition();
        Statement statement = ifStatement.getThenStatement();
        Statement statement2 = ifStatement.getElseStatement();
        if (expression.accept(this).booleanValue()) {
            return true;
        }
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            if (booleanLiteral.getValue()) {
                return statement.accept(this);
            }
            if (statement2 != null) {
                return statement2.accept(this);
            }
        }
        if (statement == null || statement2 == null) {
            return false;
        }
        return statement.accept(this) != false && statement2.accept(this) != false;
    }

    @Override
    public Boolean visitIndexExpression(IndexExpression indexExpression) {
        Expression expression = indexExpression.getRealTarget();
        if (expression != null && expression.accept(this).booleanValue()) {
            return true;
        }
        if (indexExpression.getIndex().accept(this).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        return instanceCreationExpression.getArgumentList().accept(this);
    }

    @Override
    public Boolean visitIsExpression(IsExpression isExpression) {
        return isExpression.getExpression().accept(this);
    }

    @Override
    public Boolean visitLabel(Label label) {
        return false;
    }

    @Override
    public Boolean visitLabeledStatement(LabeledStatement labeledStatement) {
        return labeledStatement.getStatement().accept(this);
    }

    @Override
    public Boolean visitLiteral(Literal literal) {
        return false;
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocation methodInvocation) {
        Expression expression = methodInvocation.getRealTarget();
        if (expression != null && expression.accept(this).booleanValue()) {
            return true;
        }
        return methodInvocation.getArgumentList().accept(this);
    }

    @Override
    public Boolean visitNamedExpression(NamedExpression namedExpression) {
        return namedExpression.getExpression().accept(this);
    }

    @Override
    public Boolean visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        return parenthesizedExpression.getExpression().accept(this);
    }

    @Override
    public Boolean visitPostfixExpression(PostfixExpression postfixExpression) {
        return false;
    }

    @Override
    public Boolean visitPrefixExpression(PrefixExpression prefixExpression) {
        return false;
    }

    @Override
    public Boolean visitPropertyAccess(PropertyAccess propertyAccess) {
        Expression expression = propertyAccess.getRealTarget();
        if (expression != null && expression.accept(this).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitRethrowExpression(RethrowExpression rethrowExpression) {
        return true;
    }

    @Override
    public Boolean visitReturnStatement(ReturnStatement returnStatement) {
        return true;
    }

    @Override
    public Boolean visitSuperExpression(SuperExpression superExpression) {
        return false;
    }

    @Override
    public Boolean visitSwitchCase(SwitchCase switchCase) {
        return this.visitStatements(switchCase.getStatements());
    }

    @Override
    public Boolean visitSwitchDefault(SwitchDefault switchDefault) {
        return this.visitStatements(switchDefault.getStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitSwitchStatement(SwitchStatement switchStatement) {
        boolean bl = this.enclosingBlockContainsBreak;
        this.enclosingBlockContainsBreak = false;
        try {
            boolean bl2 = false;
            NodeList<SwitchMember> nodeList = switchStatement.getMembers();
            SwitchMember[] switchMemberArray = nodeList.toArray(new SwitchMember[nodeList.size()]);
            for (int i = 0; i < switchMemberArray.length; ++i) {
                SwitchMember switchMember = switchMemberArray[i];
                if (switchMember instanceof SwitchDefault) {
                    bl2 = true;
                    if (switchMember.getStatements().isEmpty() && i + 1 == switchMemberArray.length) {
                        Boolean bl3 = false;
                        return bl3;
                    }
                }
                if (switchMember.getStatements().isEmpty() || switchMember.accept(this).booleanValue()) continue;
                Boolean bl4 = false;
                return bl4;
            }
            Boolean bl5 = bl2;
            return bl5;
        }
        finally {
            this.enclosingBlockContainsBreak = bl;
        }
    }

    @Override
    public Boolean visitThisExpression(ThisExpression thisExpression) {
        return false;
    }

    @Override
    public Boolean visitThrowExpression(ThrowExpression throwExpression) {
        return true;
    }

    @Override
    public Boolean visitTryStatement(TryStatement tryStatement) {
        if (tryStatement.getBody().accept(this).booleanValue()) {
            return true;
        }
        Block block = tryStatement.getFinallyBlock();
        if (block != null && block.accept(this).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitTypeName(TypeName typeName) {
        return false;
    }

    @Override
    public Boolean visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        Expression expression = variableDeclaration.getInitializer();
        if (expression != null) {
            return expression.accept(this);
        }
        return false;
    }

    @Override
    public Boolean visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        return this.visitVariableDeclarations(variableDeclarationList.getVariables());
    }

    @Override
    public Boolean visitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        NodeList<VariableDeclaration> nodeList = variableDeclarationStatement.getVariables().getVariables();
        for (int i = 0; i < nodeList.size(); ++i) {
            if (!((VariableDeclaration)nodeList.get(i)).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitWhileStatement(WhileStatement whileStatement) {
        boolean bl = this.enclosingBlockContainsBreak;
        this.enclosingBlockContainsBreak = false;
        try {
            Object object;
            Expression expression = whileStatement.getCondition();
            if (expression.accept(this).booleanValue()) {
                Boolean bl2 = true;
                return bl2;
            }
            if (expression instanceof BooleanLiteral) {
                object = (BooleanLiteral)expression;
                boolean bl3 = whileStatement.getBody().accept(this);
                if (((BooleanLiteral)object).getValue() && (bl3 || !this.enclosingBlockContainsBreak)) {
                    Boolean bl4 = true;
                    return bl4;
                }
            }
            object = false;
            return object;
        }
        finally {
            this.enclosingBlockContainsBreak = bl;
        }
    }

    private boolean visitExpressions(NodeList<Expression> nodeList) {
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            if (!((Expression)nodeList.get(i)).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean visitStatements(NodeList<Statement> nodeList) {
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            if (!((Statement)nodeList.get(i)).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean visitVariableDeclarations(NodeList<VariableDeclaration> nodeList) {
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            if (!((VariableDeclaration)nodeList.get(i)).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

