/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.Type;
import java.util.ArrayList;

public class DeadCodeVerifier
extends RecursiveAstVisitor<Void> {
    private ErrorReporter errorReporter;

    public DeadCodeVerifier(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        ValidResult validResult;
        Expression expression;
        boolean bl;
        Token token = binaryExpression.getOperator();
        boolean bl2 = token.getType() == TokenType.AMPERSAND_AMPERSAND;
        boolean bl3 = bl = token.getType() == TokenType.BAR_BAR;
        if ((bl2 || bl) && !this.isDebugConstant(expression = binaryExpression.getLeftOperand()) && (validResult = this.getConstantBooleanValue(expression)) != null) {
            if (validResult.isTrue() && bl) {
                this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, binaryExpression.getRightOperand(), new Object[0]);
                this.safelyVisit(expression);
                return null;
            }
            if (validResult.isFalse() && bl2) {
                this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, binaryExpression.getRightOperand(), new Object[0]);
                this.safelyVisit(expression);
                return null;
            }
        }
        return (Void)super.visitBinaryExpression(binaryExpression);
    }

    @Override
    public Void visitBlock(Block block) {
        NodeList<Statement> nodeList = block.getStatements();
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            Statement statement = (Statement)nodeList.get(i);
            this.safelyVisit(statement);
            if (!(statement instanceof ReturnStatement) || i == n - 1) continue;
            Statement statement2 = (Statement)nodeList.get(i + 1);
            Statement statement3 = (Statement)nodeList.get(n - 1);
            int n2 = statement2.getOffset();
            int n3 = statement3.getEnd() - n2;
            this.errorReporter.reportErrorForOffset(HintCode.DEAD_CODE, n2, n3, new Object[0]);
            return null;
        }
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        ValidResult validResult;
        Expression expression = conditionalExpression.getCondition();
        this.safelyVisit(expression);
        if (!this.isDebugConstant(expression) && (validResult = this.getConstantBooleanValue(expression)) != null) {
            if (validResult.isTrue()) {
                this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, conditionalExpression.getElseExpression(), new Object[0]);
                this.safelyVisit(conditionalExpression.getThenExpression());
                return null;
            }
            this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, conditionalExpression.getThenExpression(), new Object[0]);
            this.safelyVisit(conditionalExpression.getElseExpression());
            return null;
        }
        return (Void)super.visitConditionalExpression(conditionalExpression);
    }

    @Override
    public Void visitIfStatement(IfStatement ifStatement) {
        ValidResult validResult;
        Expression expression = ifStatement.getCondition();
        this.safelyVisit(expression);
        if (!this.isDebugConstant(expression) && (validResult = this.getConstantBooleanValue(expression)) != null) {
            if (validResult.isTrue()) {
                Statement statement = ifStatement.getElseStatement();
                if (statement != null) {
                    this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, statement, new Object[0]);
                    this.safelyVisit(ifStatement.getThenStatement());
                    return null;
                }
            } else {
                this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, ifStatement.getThenStatement(), new Object[0]);
                this.safelyVisit(ifStatement.getElseStatement());
                return null;
            }
        }
        return (Void)super.visitIfStatement(ifStatement);
    }

    @Override
    public Void visitTryStatement(TryStatement tryStatement) {
        this.safelyVisit(tryStatement.getBody());
        this.safelyVisit(tryStatement.getFinallyBlock());
        NodeList<CatchClause> nodeList = tryStatement.getCatchClauses();
        int n = nodeList.size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            AstNode astNode;
            CatchClause catchClause = (CatchClause)nodeList.get(i);
            if (catchClause.getOnKeyword() != null) {
                astNode = catchClause.getExceptionType();
                if (astNode != null && ((TypeName)astNode).getType() != null) {
                    object = ((TypeName)astNode).getType();
                    if (object.isObject()) {
                        this.safelyVisit(catchClause);
                        if (i + 1 != n) {
                            CatchClause catchClause2 = (CatchClause)nodeList.get(i + 1);
                            CatchClause n7 = (CatchClause)nodeList.get(n - 1);
                            int catchClause3 = catchClause2.getOffset();
                            int n4 = n7.getEnd() - catchClause3;
                            this.errorReporter.reportErrorForOffset(HintCode.DEAD_CODE_CATCH_FOLLOWING_CATCH, catchClause3, n4, new Object[0]);
                            return null;
                        }
                    }
                    for (Type object2 : arrayList) {
                        if (!object.isSubtypeOf(object2)) continue;
                        CatchClause catchClause2 = (CatchClause)nodeList.get(n - 1);
                        int n2 = catchClause.getOffset();
                        int n3 = catchClause2.getEnd() - n2;
                        this.errorReporter.reportErrorForOffset(HintCode.DEAD_CODE_ON_CATCH_SUBTYPE, n2, n3, object.getDisplayName(), object2.getDisplayName());
                        return null;
                    }
                    arrayList.add((Type)object);
                }
                this.safelyVisit(catchClause);
                continue;
            }
            this.safelyVisit(catchClause);
            if (i + 1 == n) continue;
            astNode = (CatchClause)nodeList.get(i + 1);
            object = (CatchClause)nodeList.get(n - 1);
            int n6 = astNode.getOffset();
            int n4 = ((AstNode)object).getEnd() - n6;
            this.errorReporter.reportErrorForOffset(HintCode.DEAD_CODE_CATCH_FOLLOWING_CATCH, n6, n4, new Object[0]);
            return null;
        }
        return null;
    }

    @Override
    public Void visitWhileStatement(WhileStatement whileStatement) {
        ValidResult validResult;
        Expression expression = whileStatement.getCondition();
        this.safelyVisit(expression);
        if (!this.isDebugConstant(expression) && (validResult = this.getConstantBooleanValue(expression)) != null && validResult.isFalse()) {
            this.errorReporter.reportErrorForNode(HintCode.DEAD_CODE, whileStatement.getBody(), new Object[0]);
            return null;
        }
        this.safelyVisit(whileStatement.getBody());
        return null;
    }

    private ValidResult getConstantBooleanValue(Expression expression) {
        if (expression instanceof BooleanLiteral) {
            if (((BooleanLiteral)expression).getValue()) {
                return new ValidResult(new DartObjectImpl(null, BoolState.from(true)));
            }
            return new ValidResult(new DartObjectImpl(null, BoolState.from(false)));
        }
        return null;
    }

    private boolean isDebugConstant(Expression expression) {
        Object object;
        Element element = null;
        if (expression instanceof Identifier) {
            object = (Identifier)expression;
            element = ((Identifier)object).getStaticElement();
        } else if (expression instanceof PropertyAccess) {
            object = (PropertyAccess)expression;
            element = ((PropertyAccess)object).getPropertyName().getStaticElement();
        }
        if (element instanceof PropertyAccessorElement) {
            object = (PropertyAccessorElement)element;
            PropertyInducingElement propertyInducingElement = object.getVariable();
            return propertyInducingElement != null && propertyInducingElement.isConst();
        }
        return false;
    }

    private void safelyVisit(AstNode astNode) {
        if (astNode != null) {
            astNode.accept(this);
        }
    }
}

