/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.type.Type;

public class Dart2JSVerifier
extends RecursiveAstVisitor<Void> {
    private ErrorReporter errorReporter;
    private static final String DOUBLE_TYPE_NAME = "double";

    public Dart2JSVerifier(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visitIsExpression(IsExpression isExpression) {
        this.checkForIsDoubleHints(isExpression);
        return (Void)super.visitIsExpression(isExpression);
    }

    private boolean checkForIsDoubleHints(IsExpression isExpression) {
        TypeName typeName = isExpression.getType();
        Type type = typeName.getType();
        if (type != null && type.getElement() != null) {
            Element element = type.getElement();
            String string = element.getName();
            LibraryElement libraryElement = element.getLibrary();
            if (string.equals(DOUBLE_TYPE_NAME) && libraryElement != null && libraryElement.isDartCore()) {
                if (isExpression.getNotOperator() == null) {
                    this.errorReporter.reportErrorForNode(HintCode.IS_DOUBLE, isExpression, new Object[0]);
                } else {
                    this.errorReporter.reportErrorForNode(HintCode.IS_NOT_DOUBLE, isExpression, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }
}

