/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.hint;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.HintCode;
import com.google.dart.engine.internal.error.ErrorReporter;
import com.google.dart.engine.internal.hint.ExitDetector;
import com.google.dart.engine.internal.type.VoidTypeImpl;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.type.TypeParameterType;

public class BestPracticesVerifier
extends RecursiveAstVisitor<Void> {
    private static final String GETTER = "getter";
    private static final String HASHCODE_GETTER_NAME = "hashCode";
    private static final String METHOD = "method";
    private static final String NULL_TYPE_NAME = "Null";
    private static final String SETTER = "setter";
    private static final String TO_INT_METHOD_NAME = "toInt";
    private ClassElement enclosingClass;
    private ErrorReporter errorReporter;

    private static ParenthesizedExpression wrapParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        if (parenthesizedExpression.getParent() instanceof ParenthesizedExpression) {
            return BestPracticesVerifier.wrapParenthesizedExpression((ParenthesizedExpression)parenthesizedExpression.getParent());
        }
        return parenthesizedExpression;
    }

    public BestPracticesVerifier(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visitArgumentList(ArgumentList argumentList) {
        this.checkForArgumentTypesNotAssignableInList(argumentList);
        return (Void)super.visitArgumentList(argumentList);
    }

    @Override
    public Void visitAsExpression(AsExpression asExpression) {
        this.checkForUnnecessaryCast(asExpression);
        return (Void)super.visitAsExpression(asExpression);
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        TokenType tokenType = assignmentExpression.getOperator().getType();
        if (tokenType != TokenType.EQ) {
            this.checkForDeprecatedMemberUse(assignmentExpression.getBestElement(), assignmentExpression);
        } else {
            this.checkForUseOfVoidResult(assignmentExpression.getRightHandSide());
        }
        return (Void)super.visitAssignmentExpression(assignmentExpression);
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.checkForDivisionOptimizationHint(binaryExpression);
        this.checkForDeprecatedMemberUse(binaryExpression.getBestElement(), binaryExpression);
        return (Void)super.visitBinaryExpression(binaryExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassElement classElement = this.enclosingClass;
        try {
            this.enclosingClass = classDeclaration.getElement();
            Void void_ = (Void)super.visitClassDeclaration(classDeclaration);
            return void_;
        }
        finally {
            this.enclosingClass = classElement;
        }
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        this.checkForDeprecatedMemberUse(exportDirective.getUriElement(), exportDirective);
        return (Void)super.visitExportDirective(exportDirective);
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        this.checkForMissingReturn(functionDeclaration.getReturnType(), functionDeclaration.getFunctionExpression().getBody());
        return (Void)super.visitFunctionDeclaration(functionDeclaration);
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        this.checkForDeprecatedMemberUse(importDirective.getUriElement(), importDirective);
        return (Void)super.visitImportDirective(importDirective);
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        this.checkForDeprecatedMemberUse(indexExpression.getBestElement(), indexExpression);
        return (Void)super.visitIndexExpression(indexExpression);
    }

    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        this.checkForDeprecatedMemberUse(instanceCreationExpression.getStaticElement(), instanceCreationExpression);
        return (Void)super.visitInstanceCreationExpression(instanceCreationExpression);
    }

    @Override
    public Void visitIsExpression(IsExpression isExpression) {
        this.checkAllTypeChecks(isExpression);
        return (Void)super.visitIsExpression(isExpression);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.checkForMissingReturn(methodDeclaration.getReturnType(), methodDeclaration.getBody());
        return (Void)super.visitMethodDeclaration(methodDeclaration);
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.checkForDeprecatedMemberUse(postfixExpression.getBestElement(), postfixExpression);
        return (Void)super.visitPostfixExpression(postfixExpression);
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        this.checkForDeprecatedMemberUse(prefixExpression.getBestElement(), prefixExpression);
        return (Void)super.visitPrefixExpression(prefixExpression);
    }

    @Override
    public Void visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        this.checkForDeprecatedMemberUse(redirectingConstructorInvocation.getStaticElement(), redirectingConstructorInvocation);
        return (Void)super.visitRedirectingConstructorInvocation(redirectingConstructorInvocation);
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        this.checkForDeprecatedMemberUseAtIdentifier(simpleIdentifier);
        return (Void)super.visitSimpleIdentifier(simpleIdentifier);
    }

    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        this.checkForDeprecatedMemberUse(superConstructorInvocation.getStaticElement(), superConstructorInvocation);
        return (Void)super.visitSuperConstructorInvocation(superConstructorInvocation);
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.checkForUseOfVoidResult(variableDeclaration.getInitializer());
        return (Void)super.visitVariableDeclaration(variableDeclaration);
    }

    private boolean checkAllTypeChecks(IsExpression isExpression) {
        LibraryElement libraryElement;
        Expression expression = isExpression.getExpression();
        TypeName typeName = isExpression.getType();
        Type type = expression.getStaticType();
        Type type2 = typeName.getType();
        if (type == null || type2 == null) {
            return false;
        }
        String string = typeName.getName().getName();
        if (type2.isDynamic() && string.equals(Keyword.DYNAMIC.getSyntax())) {
            if (isExpression.getNotOperator() == null) {
                this.errorReporter.reportErrorForNode(HintCode.UNNECESSARY_TYPE_CHECK_TRUE, isExpression, new Object[0]);
            } else {
                this.errorReporter.reportErrorForNode(HintCode.UNNECESSARY_TYPE_CHECK_FALSE, isExpression, new Object[0]);
            }
            return true;
        }
        Element element = type2.getElement();
        LibraryElement libraryElement2 = libraryElement = element != null ? element.getLibrary() : null;
        if (libraryElement != null && libraryElement.isDartCore()) {
            if (type2.isObject() || expression instanceof NullLiteral && string.equals(NULL_TYPE_NAME)) {
                if (isExpression.getNotOperator() == null) {
                    this.errorReporter.reportErrorForNode(HintCode.UNNECESSARY_TYPE_CHECK_TRUE, isExpression, new Object[0]);
                } else {
                    this.errorReporter.reportErrorForNode(HintCode.UNNECESSARY_TYPE_CHECK_FALSE, isExpression, new Object[0]);
                }
                return true;
            }
            if (string.equals(NULL_TYPE_NAME)) {
                if (isExpression.getNotOperator() == null) {
                    this.errorReporter.reportErrorForNode(HintCode.TYPE_CHECK_IS_NULL, isExpression, new Object[0]);
                } else {
                    this.errorReporter.reportErrorForNode(HintCode.TYPE_CHECK_IS_NOT_NULL, isExpression, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkForArgumentTypeNotAssignable(Expression expression, Type type, Type type2, Type type3, Type type4, ErrorCode errorCode) {
        Type type5;
        if (type2 != null && type != null && !type2.isAssignableTo(type)) {
            return false;
        }
        Type type6 = type3 != null ? type3 : type;
        Type type7 = type5 = type4 != null ? type4 : type2;
        if (type5 != null && type6 != null && !type5.isAssignableTo(type6)) {
            this.errorReporter.reportErrorForNode(errorCode, expression, type5.getDisplayName(), type6.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForArgumentTypeNotAssignableForArgument(Expression expression) {
        if (expression == null) {
            return false;
        }
        ParameterElement parameterElement = expression.getStaticParameterElement();
        Type type = parameterElement == null ? null : parameterElement.getType();
        ParameterElement parameterElement2 = expression.getPropagatedParameterElement();
        Type type2 = parameterElement2 == null ? null : parameterElement2.getType();
        return this.checkForArgumentTypeNotAssignableWithExpectedTypes(expression, type, type2, HintCode.ARGUMENT_TYPE_NOT_ASSIGNABLE);
    }

    private boolean checkForArgumentTypeNotAssignableWithExpectedTypes(Expression expression, Type type, Type type2, ErrorCode errorCode) {
        return this.checkForArgumentTypeNotAssignable(expression, type, expression.getStaticType(), type2, expression.getPropagatedType(), errorCode);
    }

    private boolean checkForArgumentTypesNotAssignableInList(ArgumentList argumentList) {
        if (argumentList == null) {
            return false;
        }
        boolean bl = false;
        for (Expression expression : argumentList.getArguments()) {
            bl |= this.checkForArgumentTypeNotAssignableForArgument(expression);
        }
        return bl;
    }

    private boolean checkForDeprecatedMemberUse(Element element, AstNode astNode) {
        if (element != null && element.isDeprecated()) {
            String string = element.getDisplayName();
            if (element instanceof ConstructorElement) {
                ConstructorElement constructorElement = (ConstructorElement)element;
                string = constructorElement.getEnclosingElement().getDisplayName();
                if (!constructorElement.getDisplayName().isEmpty()) {
                    string = string + '.' + constructorElement.getDisplayName();
                }
            }
            this.errorReporter.reportErrorForNode(HintCode.DEPRECATED_MEMBER_USE, astNode, string);
            return true;
        }
        return false;
    }

    private boolean checkForDeprecatedMemberUseAtIdentifier(SimpleIdentifier simpleIdentifier) {
        if (simpleIdentifier.inDeclarationContext()) {
            return false;
        }
        AstNode astNode = simpleIdentifier.getParent();
        if (astNode instanceof ConstructorName && simpleIdentifier == ((ConstructorName)astNode).getName() || astNode instanceof SuperConstructorInvocation && simpleIdentifier == ((SuperConstructorInvocation)astNode).getConstructorName() || astNode instanceof HideCombinator) {
            return false;
        }
        return this.checkForDeprecatedMemberUse(simpleIdentifier.getBestElement(), simpleIdentifier);
    }

    private boolean checkForDivisionOptimizationHint(BinaryExpression binaryExpression) {
        MethodInvocation methodInvocation;
        ParenthesizedExpression parenthesizedExpression;
        if (!binaryExpression.getOperator().getType().equals((Object)TokenType.SLASH)) {
            return false;
        }
        MethodElement methodElement = binaryExpression.getBestElement();
        if (methodElement == null) {
            return false;
        }
        LibraryElement libraryElement = methodElement.getLibrary();
        if (libraryElement != null && !libraryElement.isDartCore()) {
            return false;
        }
        if (binaryExpression.getParent() instanceof ParenthesizedExpression && (parenthesizedExpression = BestPracticesVerifier.wrapParenthesizedExpression((ParenthesizedExpression)binaryExpression.getParent())).getParent() instanceof MethodInvocation && TO_INT_METHOD_NAME.equals((methodInvocation = (MethodInvocation)parenthesizedExpression.getParent()).getMethodName().getName()) && methodInvocation.getArgumentList().getArguments().isEmpty()) {
            this.errorReporter.reportErrorForNode(HintCode.DIVISION_OPTIMIZATION, methodInvocation, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForMissingReturn(TypeName typeName, FunctionBody functionBody) {
        if (typeName == null || functionBody == null) {
            return false;
        }
        if (!(functionBody instanceof BlockFunctionBody)) {
            return false;
        }
        Type type = typeName.getType();
        if (type == null || type.isVoid()) {
            return false;
        }
        BlockFunctionBody blockFunctionBody = (BlockFunctionBody)functionBody;
        if (!blockFunctionBody.accept(new ExitDetector()).booleanValue()) {
            this.errorReporter.reportErrorForNode(HintCode.MISSING_RETURN, typeName, type.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForOverrideEqualsButNotHashCode(ClassDeclaration classDeclaration) {
        PropertyAccessorElement propertyAccessorElement;
        ClassElement classElement = classDeclaration.getElement();
        if (classElement == null) {
            return false;
        }
        MethodElement methodElement = classElement.getMethod(TokenType.EQ_EQ.getLexeme());
        if (methodElement != null && (propertyAccessorElement = classElement.getGetter(HASHCODE_GETTER_NAME)) == null) {
            this.errorReporter.reportErrorForNode(HintCode.OVERRIDE_EQUALS_BUT_NOT_HASH_CODE, classDeclaration.getName(), classElement.getDisplayName());
            return true;
        }
        return false;
    }

    private boolean checkForOverridingPrivateMember(MethodDeclaration methodDeclaration) {
        if (this.enclosingClass == null) {
            return false;
        }
        if (!Identifier.isPrivateName(methodDeclaration.getName().getName())) {
            return false;
        }
        ExecutableElement executableElement = methodDeclaration.getElement();
        if (executableElement == null) {
            return false;
        }
        String string = executableElement.getName();
        boolean bl = executableElement instanceof PropertyAccessorElement;
        InterfaceType interfaceType = this.enclosingClass.getSupertype();
        if (interfaceType == null) {
            return false;
        }
        ClassElement classElement = interfaceType.getElement();
        while (classElement != null) {
            if (!this.enclosingClass.getLibrary().equals(classElement.getLibrary())) {
                ExecutableElement executableElement2;
                if (bl) {
                    PropertyAccessorElement[] propertyAccessorElementArray;
                    executableElement2 = null;
                    for (PropertyAccessorElement propertyAccessorElement : propertyAccessorElementArray = classElement.getAccessors()) {
                        if (!string.equals(propertyAccessorElement.getName())) continue;
                        executableElement2 = propertyAccessorElement;
                        break;
                    }
                    if (executableElement2 != null) {
                        String string2 = ((PropertyAccessorElement)executableElement).isGetter() ? GETTER : SETTER;
                        this.errorReporter.reportErrorForNode(HintCode.OVERRIDDING_PRIVATE_MEMBER, methodDeclaration.getName(), string2, executableElement.getDisplayName(), classElement.getDisplayName());
                        return true;
                    }
                } else {
                    executableElement2 = classElement.getMethod(string);
                    if (executableElement2 != null) {
                        this.errorReporter.reportErrorForNode(HintCode.OVERRIDDING_PRIVATE_MEMBER, methodDeclaration.getName(), METHOD, executableElement.getDisplayName(), classElement.getDisplayName());
                        return true;
                    }
                }
            }
            classElement = (interfaceType = classElement.getSupertype()) != null ? interfaceType.getElement() : null;
        }
        return false;
    }

    private boolean checkForUnnecessaryCast(AsExpression asExpression) {
        Expression expression = asExpression.getExpression();
        TypeName typeName = asExpression.getType();
        Type type = expression.getStaticType();
        Type type2 = typeName.getType();
        if (!(type == null || type2 == null || type.isDynamic() || type2.isDynamic() || type instanceof TypeParameterType || type2 instanceof TypeParameterType || !type.isSubtypeOf(type2))) {
            this.errorReporter.reportErrorForNode(HintCode.UNNECESSARY_CAST, asExpression, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean checkForUseOfVoidResult(Expression expression) {
        if (expression == null || !(expression instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation methodInvocation = (MethodInvocation)expression;
        if (methodInvocation.getStaticType() == VoidTypeImpl.getInstance()) {
            SimpleIdentifier simpleIdentifier = methodInvocation.getMethodName();
            this.errorReporter.reportErrorForNode(HintCode.USE_OF_VOID_RESULT, simpleIdentifier, simpleIdentifier.getName());
            return true;
        }
        return false;
    }
}

