/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.error;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.AnalysisErrorWithProperties;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.Source;

public class ErrorReporter {
    private AnalysisErrorListener errorListener;
    private Source defaultSource;
    private Source source;

    public ErrorReporter(AnalysisErrorListener analysisErrorListener, Source source) {
        if (analysisErrorListener == null) {
            throw new IllegalArgumentException("An error listener must be provided");
        }
        if (source == null) {
            throw new IllegalArgumentException("A default source must be provided");
        }
        this.errorListener = analysisErrorListener;
        this.defaultSource = source;
        this.source = source;
    }

    public AnalysisErrorWithProperties newErrorWithProperties(ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        return new AnalysisErrorWithProperties(this.source, astNode.getOffset(), astNode.getLength(), errorCode, objectArray);
    }

    public void reportError(AnalysisError analysisError) {
        this.errorListener.onError(analysisError);
    }

    public void reportErrorForNode(ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        this.reportErrorForOffset(errorCode, astNode.getOffset(), astNode.getLength(), objectArray);
    }

    public void reportErrorForElement(ErrorCode errorCode, Element element, Object ... objectArray) {
        this.reportErrorForOffset(errorCode, element.getNameOffset(), element.getDisplayName().length(), objectArray);
    }

    public void reportErrorForOffset(ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, n, n2, errorCode, objectArray));
    }

    public void reportErrorForToken(ErrorCode errorCode, Token token, Object ... objectArray) {
        this.reportErrorForOffset(errorCode, token.getOffset(), token.getLength(), objectArray);
    }

    public void setSource(Source source) {
        this.source = source == null ? this.defaultSource : source;
    }
}

