/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.internal.element.member.ExecutableMember;
import com.google.dart.engine.internal.element.member.FieldMember;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;

public class PropertyAccessorMember
extends ExecutableMember
implements PropertyAccessorElement {
    public static PropertyAccessorElement from(PropertyAccessorElement propertyAccessorElement, InterfaceType interfaceType) {
        Type[] typeArray;
        Type[] typeArray2;
        FunctionType functionType;
        if (propertyAccessorElement == null || interfaceType.getTypeArguments().length == 0) {
            return propertyAccessorElement;
        }
        FunctionType functionType2 = propertyAccessorElement.getType();
        if (functionType2.equals(functionType = functionType2.substitute(typeArray2 = interfaceType.getTypeArguments(), typeArray = interfaceType.getElement().getType().getTypeArguments()))) {
            return propertyAccessorElement;
        }
        return new PropertyAccessorMember(propertyAccessorElement, interfaceType);
    }

    public PropertyAccessorMember(PropertyAccessorElement propertyAccessorElement, InterfaceType interfaceType) {
        super(propertyAccessorElement, interfaceType);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitPropertyAccessorElement(this);
    }

    @Override
    public PropertyAccessorElement getBaseElement() {
        return (PropertyAccessorElement)super.getBaseElement();
    }

    @Override
    public PropertyAccessorElement getCorrespondingGetter() {
        return PropertyAccessorMember.from(this.getBaseElement().getCorrespondingGetter(), this.getDefiningType());
    }

    @Override
    public PropertyAccessorElement getCorrespondingSetter() {
        return PropertyAccessorMember.from(this.getBaseElement().getCorrespondingSetter(), this.getDefiningType());
    }

    @Override
    public Element getEnclosingElement() {
        return this.getBaseElement().getEnclosingElement();
    }

    @Override
    public PropertyInducingElement getVariable() {
        PropertyInducingElement propertyInducingElement = this.getBaseElement().getVariable();
        if (propertyInducingElement instanceof FieldElement) {
            return FieldMember.from((FieldElement)propertyInducingElement, this.getDefiningType());
        }
        return propertyInducingElement;
    }

    @Override
    public boolean isAbstract() {
        return this.getBaseElement().isAbstract();
    }

    @Override
    public boolean isGetter() {
        return this.getBaseElement().isGetter();
    }

    @Override
    public boolean isSetter() {
        return this.getBaseElement().isSetter();
    }

    public String toString() {
        PropertyAccessorElement propertyAccessorElement = this.getBaseElement();
        ParameterElement[] parameterElementArray = this.getParameters();
        FunctionType functionType = this.getType();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isGetter()) {
            stringBuilder.append("get ");
        } else {
            stringBuilder.append("set ");
        }
        stringBuilder.append(propertyAccessorElement.getEnclosingElement().getDisplayName());
        stringBuilder.append(".");
        stringBuilder.append(propertyAccessorElement.getDisplayName());
        stringBuilder.append("(");
        int n = parameterElementArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterElementArray[i]).toString();
        }
        stringBuilder.append(")");
        if (functionType != null) {
            stringBuilder.append(" \u2192 ");
            stringBuilder.append(functionType.getReturnType());
        }
        return stringBuilder.toString();
    }

    @Override
    protected InterfaceType getDefiningType() {
        return (InterfaceType)super.getDefiningType();
    }
}

