/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FieldFormalParameterElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.internal.element.member.ConstructorMember;
import com.google.dart.engine.internal.element.member.FieldFormalParameterMember;
import com.google.dart.engine.internal.element.member.MethodMember;
import com.google.dart.engine.internal.element.member.PropertyAccessorMember;
import com.google.dart.engine.internal.element.member.VariableMember;
import com.google.dart.engine.internal.type.TypeParameterTypeImpl;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.ParameterizedType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.dart.ParameterKind;
import com.google.dart.engine.utilities.source.SourceRange;

public class ParameterMember
extends VariableMember
implements ParameterElement {
    public static ParameterElement from(ParameterElement parameterElement, ParameterizedType parameterizedType) {
        Type[] typeArray;
        Type[] typeArray2;
        Type type;
        Type type2;
        if (parameterElement == null || parameterizedType.getTypeArguments().length == 0) {
            return parameterElement;
        }
        boolean bl = parameterElement instanceof FieldFormalParameterElement;
        if (!bl && (type2 = parameterElement.getType()).equals(type = type2.substitute(typeArray2 = parameterizedType.getTypeArguments(), typeArray = TypeParameterTypeImpl.getTypes(parameterizedType.getTypeParameters())))) {
            return parameterElement;
        }
        if (bl) {
            return new FieldFormalParameterMember((FieldFormalParameterElement)parameterElement, parameterizedType);
        }
        return new ParameterMember(parameterElement, parameterizedType);
    }

    public ParameterMember(ParameterElement parameterElement, ParameterizedType parameterizedType) {
        super(parameterElement, parameterizedType);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitParameterElement(this);
    }

    @Override
    public <E extends Element> E getAncestor(Class<E> clazz) {
        E e = this.getBaseElement().getAncestor(clazz);
        ParameterizedType parameterizedType = this.getDefiningType();
        if (parameterizedType instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)parameterizedType;
            if (e instanceof ConstructorElement) {
                return (E)ConstructorMember.from((ConstructorElement)e, interfaceType);
            }
            if (e instanceof MethodElement) {
                return (E)MethodMember.from((MethodElement)e, interfaceType);
            }
            if (e instanceof PropertyAccessorElement) {
                return (E)PropertyAccessorMember.from((PropertyAccessorElement)e, interfaceType);
            }
        }
        return e;
    }

    @Override
    public ParameterElement getBaseElement() {
        return (ParameterElement)super.getBaseElement();
    }

    @Override
    public SourceRange getDefaultValueRange() {
        return this.getBaseElement().getDefaultValueRange();
    }

    @Override
    public Element getEnclosingElement() {
        return this.getBaseElement().getEnclosingElement();
    }

    @Override
    public ParameterKind getParameterKind() {
        return this.getBaseElement().getParameterKind();
    }

    @Override
    public ParameterElement[] getParameters() {
        ParameterElement[] parameterElementArray = this.getBaseElement().getParameters();
        int n = parameterElementArray.length;
        if (n == 0) {
            return parameterElementArray;
        }
        ParameterElement[] parameterElementArray2 = new ParameterElement[n];
        for (int i = 0; i < n; ++i) {
            parameterElementArray2[i] = ParameterMember.from(parameterElementArray[i], this.getDefiningType());
        }
        return parameterElementArray2;
    }

    @Override
    public SourceRange getVisibleRange() {
        return this.getBaseElement().getVisibleRange();
    }

    @Override
    public boolean isInitializingFormal() {
        return this.getBaseElement().isInitializingFormal();
    }

    public String toString() {
        ParameterElement parameterElement = this.getBaseElement();
        String string = "";
        String string2 = "";
        switch (parameterElement.getParameterKind()) {
            case NAMED: {
                string = "{";
                string2 = "}";
                break;
            }
            case POSITIONAL: {
                string = "[";
                string2 = "]";
                break;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(this.getType());
        stringBuilder.append(" ");
        stringBuilder.append(parameterElement.getDisplayName());
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.getParameters(), elementVisitor);
    }
}

