/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.member.ExecutableMember;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;

public class MethodMember
extends ExecutableMember
implements MethodElement {
    public static MethodElement from(MethodElement methodElement, InterfaceType interfaceType) {
        Type[] typeArray;
        Type[] typeArray2;
        FunctionType functionType;
        if (methodElement == null || interfaceType.getTypeArguments().length == 0) {
            return methodElement;
        }
        FunctionType functionType2 = methodElement.getType();
        if (functionType2.equals(functionType = functionType2.substitute(typeArray2 = interfaceType.getTypeArguments(), typeArray = interfaceType.getElement().getType().getTypeArguments()))) {
            return methodElement;
        }
        return new MethodMember(methodElement, interfaceType);
    }

    public MethodMember(MethodElement methodElement, InterfaceType interfaceType) {
        super(methodElement, interfaceType);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitMethodElement(this);
    }

    @Override
    public MethodElement getBaseElement() {
        return (MethodElement)super.getBaseElement();
    }

    @Override
    public ClassElement getEnclosingElement() {
        return this.getBaseElement().getEnclosingElement();
    }

    @Override
    public MethodDeclaration getNode() throws AnalysisException {
        return this.getBaseElement().getNode();
    }

    @Override
    public boolean isAbstract() {
        return this.getBaseElement().isAbstract();
    }

    public String toString() {
        MethodElement methodElement = this.getBaseElement();
        ParameterElement[] parameterElementArray = this.getParameters();
        FunctionType functionType = this.getType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(methodElement.getEnclosingElement().getDisplayName());
        stringBuilder.append(".");
        stringBuilder.append(methodElement.getDisplayName());
        stringBuilder.append("(");
        int n = parameterElementArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterElementArray[i]).toString();
        }
        stringBuilder.append(")");
        if (functionType != null) {
            stringBuilder.append(" \u2192 ");
            stringBuilder.append(functionType.getReturnType());
        }
        return stringBuilder.toString();
    }
}

