/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.internal.type.TypeParameterTypeImpl;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.ParameterizedType;
import com.google.dart.engine.type.Type;

public abstract class Member
implements Element {
    private Element baseElement;
    private ParameterizedType definingType;

    public Member(Element element, ParameterizedType parameterizedType) {
        this.baseElement = element;
        this.definingType = parameterizedType;
    }

    @Override
    public String computeDocumentationComment() throws AnalysisException {
        return this.baseElement.computeDocumentationComment();
    }

    @Override
    public <E extends Element> E getAncestor(Class<E> clazz) {
        return this.getBaseElement().getAncestor(clazz);
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    @Override
    public AnalysisContext getContext() {
        return this.baseElement.getContext();
    }

    @Override
    public String getDisplayName() {
        return this.baseElement.getDisplayName();
    }

    @Override
    public ElementKind getKind() {
        return this.baseElement.getKind();
    }

    @Override
    public LibraryElement getLibrary() {
        return this.baseElement.getLibrary();
    }

    @Override
    public ElementLocation getLocation() {
        return this.baseElement.getLocation();
    }

    @Override
    public ElementAnnotation[] getMetadata() {
        return this.baseElement.getMetadata();
    }

    @Override
    public String getName() {
        return this.baseElement.getName();
    }

    @Override
    public int getNameOffset() {
        return this.baseElement.getNameOffset();
    }

    @Override
    public AstNode getNode() throws AnalysisException {
        return this.baseElement.getNode();
    }

    @Override
    public Source getSource() {
        return this.baseElement.getSource();
    }

    @Override
    public CompilationUnit getUnit() throws AnalysisException {
        return this.baseElement.getUnit();
    }

    @Override
    public boolean isAccessibleIn(LibraryElement libraryElement) {
        return this.baseElement.isAccessibleIn(libraryElement);
    }

    @Override
    public boolean isDeprecated() {
        return this.baseElement.isDeprecated();
    }

    @Override
    public boolean isOverride() {
        return this.baseElement.isOverride();
    }

    @Override
    public boolean isPrivate() {
        return this.baseElement.isPrivate();
    }

    @Override
    public boolean isPublic() {
        return this.baseElement.isPublic();
    }

    @Override
    public boolean isSynthetic() {
        return this.baseElement.isSynthetic();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
    }

    protected ParameterizedType getDefiningType() {
        return this.definingType;
    }

    protected void safelyVisitChild(Element element, ElementVisitor<?> elementVisitor) {
        if (element != null) {
            element.accept(elementVisitor);
        }
    }

    protected void safelyVisitChildren(Element[] elementArray, ElementVisitor<?> elementVisitor) {
        if (elementArray != null) {
            for (Element element : elementArray) {
                element.accept(elementVisitor);
            }
        }
    }

    protected <E extends Type> E substituteFor(E e) {
        Type[] typeArray = this.definingType.getTypeArguments();
        Type[] typeArray2 = TypeParameterTypeImpl.getTypes(this.definingType.getTypeParameters());
        return (E)e.substitute(typeArray, typeArray2);
    }

    protected InterfaceType[] substituteFor(InterfaceType[] interfaceTypeArray) {
        int n = interfaceTypeArray.length;
        InterfaceType[] interfaceTypeArray2 = new InterfaceType[n];
        for (int i = 0; i < n; ++i) {
            interfaceTypeArray2[i] = this.substituteFor(interfaceTypeArray[i]);
        }
        return interfaceTypeArray2;
    }
}

