/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.internal.element.member.PropertyAccessorMember;
import com.google.dart.engine.internal.element.member.VariableMember;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.ParameterizedType;
import com.google.dart.engine.type.Type;

public class FieldMember
extends VariableMember
implements FieldElement {
    public static FieldElement from(FieldElement fieldElement, InterfaceType interfaceType) {
        Type[] typeArray;
        if (fieldElement == null || interfaceType.getTypeArguments().length == 0) {
            return fieldElement;
        }
        Type type = fieldElement.getType();
        if (type == null) {
            return fieldElement;
        }
        Type[] typeArray2 = interfaceType.getTypeArguments();
        Type type2 = type.substitute(typeArray2, typeArray = interfaceType.getElement().getType().getTypeArguments());
        if (type.equals(type2)) {
            return fieldElement;
        }
        return new FieldMember(fieldElement, interfaceType);
    }

    public FieldMember(FieldElement fieldElement, InterfaceType interfaceType) {
        super(fieldElement, (ParameterizedType)interfaceType);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitFieldElement(this);
    }

    @Override
    public FieldElement getBaseElement() {
        return (FieldElement)super.getBaseElement();
    }

    @Override
    public ClassElement getEnclosingElement() {
        return this.getBaseElement().getEnclosingElement();
    }

    @Override
    public PropertyAccessorElement getGetter() {
        return PropertyAccessorMember.from(this.getBaseElement().getGetter(), this.getDefiningType());
    }

    @Override
    public PropertyAccessorElement getSetter() {
        return PropertyAccessorMember.from(this.getBaseElement().getSetter(), this.getDefiningType());
    }

    @Override
    public boolean isStatic() {
        return this.getBaseElement().isStatic();
    }

    @Override
    protected InterfaceType getDefiningType() {
        return (InterfaceType)super.getDefiningType();
    }
}

