/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.member.Member;
import com.google.dart.engine.internal.element.member.ParameterMember;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;

public abstract class ExecutableMember
extends Member
implements ExecutableElement {
    public ExecutableMember(ExecutableElement executableElement, InterfaceType interfaceType) {
        super(executableElement, interfaceType);
    }

    @Override
    public ExecutableElement getBaseElement() {
        return (ExecutableElement)super.getBaseElement();
    }

    @Override
    public FunctionElement[] getFunctions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelElement[] getLabels() {
        return this.getBaseElement().getLabels();
    }

    @Override
    public LocalVariableElement[] getLocalVariables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterElement[] getParameters() {
        ParameterElement[] parameterElementArray = this.getBaseElement().getParameters();
        int n = parameterElementArray.length;
        if (n == 0) {
            return parameterElementArray;
        }
        ParameterElement[] parameterElementArray2 = new ParameterElement[n];
        for (int i = 0; i < n; ++i) {
            parameterElementArray2[i] = ParameterMember.from(parameterElementArray[i], this.getDefiningType());
        }
        return parameterElementArray2;
    }

    @Override
    public Type getReturnType() {
        return this.substituteFor(this.getBaseElement().getReturnType());
    }

    @Override
    public FunctionType getType() {
        return this.substituteFor(this.getBaseElement().getType());
    }

    @Override
    public boolean isOperator() {
        return this.getBaseElement().isOperator();
    }

    @Override
    public boolean isStatic() {
        return this.getBaseElement().isStatic();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.getBaseElement().getFunctions(), elementVisitor);
        this.safelyVisitChildren(this.getLabels(), elementVisitor);
        this.safelyVisitChildren(this.getBaseElement().getLocalVariables(), elementVisitor);
        this.safelyVisitChildren(this.getParameters(), elementVisitor);
    }
}

