/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.member;

import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.member.ExecutableMember;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;

public class ConstructorMember
extends ExecutableMember
implements ConstructorElement {
    public static ConstructorElement from(ConstructorElement constructorElement, InterfaceType interfaceType) {
        Type[] typeArray;
        if (constructorElement == null || interfaceType.getTypeArguments().length == 0) {
            return constructorElement;
        }
        FunctionType functionType = constructorElement.getType();
        if (functionType == null) {
            return constructorElement;
        }
        Type[] typeArray2 = interfaceType.getTypeArguments();
        FunctionType functionType2 = functionType.substitute(typeArray2, typeArray = interfaceType.getElement().getType().getTypeArguments());
        if (functionType.equals(functionType2)) {
            return constructorElement;
        }
        return new ConstructorMember(constructorElement, interfaceType);
    }

    public ConstructorMember(ConstructorElement constructorElement, InterfaceType interfaceType) {
        super(constructorElement, interfaceType);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitConstructorElement(this);
    }

    @Override
    public ConstructorElement getBaseElement() {
        return (ConstructorElement)super.getBaseElement();
    }

    @Override
    public ClassElement getEnclosingElement() {
        return this.getBaseElement().getEnclosingElement();
    }

    @Override
    public ConstructorDeclaration getNode() throws AnalysisException {
        return this.getBaseElement().getNode();
    }

    @Override
    public ConstructorElement getRedirectedConstructor() {
        return ConstructorMember.from(this.getBaseElement().getRedirectedConstructor(), this.getDefiningType());
    }

    @Override
    public boolean isConst() {
        return this.getBaseElement().isConst();
    }

    @Override
    public boolean isDefaultConstructor() {
        return this.getBaseElement().isDefaultConstructor();
    }

    @Override
    public boolean isFactory() {
        return this.getBaseElement().isFactory();
    }

    public String toString() {
        ConstructorElement constructorElement = this.getBaseElement();
        ParameterElement[] parameterElementArray = this.getParameters();
        FunctionType functionType = this.getType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(constructorElement.getEnclosingElement().getDisplayName());
        String string = this.getDisplayName();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(".");
            stringBuilder.append(string);
        }
        stringBuilder.append("(");
        int n = parameterElementArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterElementArray[i]).toString();
        }
        stringBuilder.append(")");
        if (functionType != null) {
            stringBuilder.append(" \u2192 ");
            stringBuilder.append(functionType.getReturnType());
        }
        return stringBuilder.toString();
    }

    @Override
    protected InterfaceType getDefiningType() {
        return (InterfaceType)super.getDefiningType();
    }
}

