/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.handle;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TopLevelVariableElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.handle.ClassElementHandle;
import com.google.dart.engine.internal.element.handle.CompilationUnitElementHandle;
import com.google.dart.engine.internal.element.handle.ConstructorElementHandle;
import com.google.dart.engine.internal.element.handle.ExportElementHandle;
import com.google.dart.engine.internal.element.handle.FieldElementHandle;
import com.google.dart.engine.internal.element.handle.FunctionElementHandle;
import com.google.dart.engine.internal.element.handle.FunctionTypeAliasElementHandle;
import com.google.dart.engine.internal.element.handle.ImportElementHandle;
import com.google.dart.engine.internal.element.handle.LabelElementHandle;
import com.google.dart.engine.internal.element.handle.LibraryElementHandle;
import com.google.dart.engine.internal.element.handle.LocalVariableElementHandle;
import com.google.dart.engine.internal.element.handle.MethodElementHandle;
import com.google.dart.engine.internal.element.handle.ParameterElementHandle;
import com.google.dart.engine.internal.element.handle.PrefixElementHandle;
import com.google.dart.engine.internal.element.handle.PropertyAccessorElementHandle;
import com.google.dart.engine.internal.element.handle.TopLevelVariableElementHandle;
import com.google.dart.engine.internal.element.handle.TypeParameterElementHandle;
import com.google.dart.engine.source.Source;
import java.lang.ref.WeakReference;

public abstract class ElementHandle
implements Element {
    private AnalysisContext context;
    private ElementLocation location;
    private WeakReference<Element> elementReference;

    public static <E extends Element> E forElement(E e) {
        if (e instanceof ElementHandle) {
            return e;
        }
        switch (e.getKind()) {
            case CLASS: {
                return (E)new ClassElementHandle((ClassElement)e);
            }
            case COMPILATION_UNIT: {
                return (E)new CompilationUnitElementHandle((CompilationUnitElement)e);
            }
            case CONSTRUCTOR: {
                return (E)new ConstructorElementHandle((ConstructorElement)e);
            }
            case EXPORT: {
                return (E)new ExportElementHandle((ExportElement)e);
            }
            case FIELD: {
                return (E)new FieldElementHandle((FieldElement)e);
            }
            case FUNCTION: {
                return (E)new FunctionElementHandle((FunctionElement)e);
            }
            case GETTER: {
                return (E)new PropertyAccessorElementHandle((PropertyAccessorElement)e);
            }
            case IMPORT: {
                return (E)new ImportElementHandle((ImportElement)e);
            }
            case LABEL: {
                return (E)new LabelElementHandle((LabelElement)e);
            }
            case LIBRARY: {
                return (E)new LibraryElementHandle((LibraryElement)e);
            }
            case LOCAL_VARIABLE: {
                return (E)new LocalVariableElementHandle((LocalVariableElement)e);
            }
            case METHOD: {
                return (E)new MethodElementHandle((MethodElement)e);
            }
            case PARAMETER: {
                return (E)new ParameterElementHandle((ParameterElement)e);
            }
            case PREFIX: {
                return (E)new PrefixElementHandle((PrefixElement)e);
            }
            case SETTER: {
                return (E)new PropertyAccessorElementHandle((PropertyAccessorElement)e);
            }
            case TOP_LEVEL_VARIABLE: {
                return (E)new TopLevelVariableElementHandle((TopLevelVariableElement)e);
            }
            case FUNCTION_TYPE_ALIAS: {
                return (E)new FunctionTypeAliasElementHandle((FunctionTypeAliasElement)e);
            }
            case TYPE_PARAMETER: {
                return (E)new TypeParameterElementHandle((TypeParameterElement)e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static <E extends Element> E[] forElements(E[] EArray) {
        int n = EArray.length;
        Element[] elementArray = (Element[])EArray.clone();
        for (int i = 0; i < n; ++i) {
            elementArray[i] = ElementHandle.forElement(EArray[i]);
        }
        return elementArray;
    }

    public ElementHandle(Element element) {
        this.context = element.getContext();
        this.location = element.getLocation();
        this.elementReference = new WeakReference<Element>(element);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return this.getActualElement().accept(elementVisitor);
    }

    @Override
    public String computeDocumentationComment() throws AnalysisException {
        return this.getActualElement().computeDocumentationComment();
    }

    public boolean equals(Object object) {
        return object instanceof Element && ((Element)object).getLocation().equals(this.location);
    }

    @Override
    public <E extends Element> E getAncestor(Class<E> clazz) {
        return this.getActualElement().getAncestor(clazz);
    }

    @Override
    public AnalysisContext getContext() {
        return this.context;
    }

    @Override
    public String getDisplayName() {
        return this.getActualElement().getDisplayName();
    }

    @Override
    public Element getEnclosingElement() {
        return this.getActualElement().getEnclosingElement();
    }

    @Override
    public LibraryElement getLibrary() {
        return this.getAncestor(LibraryElement.class);
    }

    @Override
    public ElementLocation getLocation() {
        return this.location;
    }

    @Override
    public ElementAnnotation[] getMetadata() {
        return this.getActualElement().getMetadata();
    }

    @Override
    public String getName() {
        return this.getActualElement().getName();
    }

    @Override
    public int getNameOffset() {
        return this.getActualElement().getNameOffset();
    }

    @Override
    public AstNode getNode() throws AnalysisException {
        return this.getActualElement().getNode();
    }

    @Override
    public Source getSource() {
        return this.getActualElement().getSource();
    }

    @Override
    public CompilationUnit getUnit() throws AnalysisException {
        return this.getActualElement().getUnit();
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Override
    public boolean isAccessibleIn(LibraryElement libraryElement) {
        return this.getActualElement().isAccessibleIn(libraryElement);
    }

    @Override
    public boolean isDeprecated() {
        return this.getActualElement().isDeprecated();
    }

    @Override
    public boolean isOverride() {
        return this.getActualElement().isOverride();
    }

    @Override
    public boolean isPrivate() {
        return this.getActualElement().isPrivate();
    }

    @Override
    public boolean isPublic() {
        return this.getActualElement().isPublic();
    }

    @Override
    public boolean isSynthetic() {
        return this.getActualElement().isSynthetic();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        this.getActualElement().visitChildren(elementVisitor);
    }

    protected Element getActualElement() {
        Element element = (Element)this.elementReference.get();
        if (element == null) {
            element = this.context.getElement(this.location);
            this.elementReference = new WeakReference<Element>(element);
        }
        return element;
    }
}

