/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.angular;

import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.angular.AngularDirectiveElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.internal.element.angular.AngularHasSelectorElementImpl;
import com.google.dart.engine.internal.element.angular.AngularPropertyElementImpl;

public class AngularDirectiveElementImpl
extends AngularHasSelectorElementImpl
implements AngularDirectiveElement {
    private int offset;
    private AngularPropertyElement[] properties = AngularPropertyElement.EMPTY_ARRAY;

    public AngularDirectiveElementImpl(int n) {
        super(null, -1);
        this.offset = n;
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitAngularDirectiveElement(this);
    }

    @Override
    public String getDisplayName() {
        return this.getSelector().getDisplayName();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.ANGULAR_DIRECTIVE;
    }

    @Override
    public AngularPropertyElement[] getProperties() {
        return this.properties;
    }

    @Override
    public boolean isClass(String string) {
        Element element = this.getEnclosingElement();
        return element instanceof ClassElement && element.getName().equals(string);
    }

    public void setProperties(AngularPropertyElement[] angularPropertyElementArray) {
        for (AngularPropertyElement angularPropertyElement : angularPropertyElementArray) {
            this.encloseElement((AngularPropertyElementImpl)angularPropertyElement);
        }
        this.properties = angularPropertyElementArray;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        this.safelyVisitChildren(this.properties, elementVisitor);
        super.visitChildren(elementVisitor);
    }

    @Override
    protected String getIdentifier() {
        return "NgDirective@" + this.offset;
    }
}

