/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element.angular;

import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.element.angular.AngularScopePropertyElement;
import com.google.dart.engine.internal.element.angular.AngularHasSelectorElementImpl;
import com.google.dart.engine.internal.element.angular.AngularPropertyElementImpl;
import com.google.dart.engine.internal.element.angular.AngularScopePropertyElementImpl;
import com.google.dart.engine.source.Source;

public class AngularComponentElementImpl
extends AngularHasSelectorElementImpl
implements AngularComponentElement {
    private final int annotationOffset;
    private AngularPropertyElement[] properties = AngularPropertyElement.EMPTY_ARRAY;
    private AngularScopePropertyElement[] scopeProperties = AngularScopePropertyElement.EMPTY_ARRAY;
    private String styleUri;
    private int styleUriOffset;
    private String templateUri;
    private Source templateSource;
    private int templateUriOffset;

    public AngularComponentElementImpl(String string, int n, int n2) {
        super(string, n);
        this.annotationOffset = n2;
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitAngularComponentElement(this);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.ANGULAR_COMPONENT;
    }

    @Override
    public AngularPropertyElement[] getProperties() {
        return this.properties;
    }

    @Override
    public AngularScopePropertyElement[] getScopeProperties() {
        return this.scopeProperties;
    }

    @Override
    public String getStyleUri() {
        return this.styleUri;
    }

    @Override
    public int getStyleUriOffset() {
        return this.styleUriOffset;
    }

    @Override
    public Source getTemplateSource() {
        return this.templateSource;
    }

    @Override
    public String getTemplateUri() {
        return this.templateUri;
    }

    @Override
    public int getTemplateUriOffset() {
        return this.templateUriOffset;
    }

    public void setProperties(AngularPropertyElement[] angularPropertyElementArray) {
        for (AngularPropertyElement angularPropertyElement : angularPropertyElementArray) {
            this.encloseElement((AngularPropertyElementImpl)angularPropertyElement);
        }
        this.properties = angularPropertyElementArray;
    }

    public void setScopeProperties(AngularScopePropertyElement[] angularScopePropertyElementArray) {
        for (AngularScopePropertyElement angularScopePropertyElement : angularScopePropertyElementArray) {
            this.encloseElement((AngularScopePropertyElementImpl)angularScopePropertyElement);
        }
        this.scopeProperties = angularScopePropertyElementArray;
    }

    public void setStyleUri(String string) {
        this.styleUri = string;
    }

    public void setStyleUriOffset(int n) {
        this.styleUriOffset = n;
    }

    public void setTemplateSource(Source source) {
        this.templateSource = source;
    }

    public void setTemplateUri(String string) {
        this.templateUri = string;
    }

    public void setTemplateUriOffset(int n) {
        this.templateUriOffset = n;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        this.safelyVisitChildren(this.properties, elementVisitor);
        this.safelyVisitChildren(this.scopeProperties, elementVisitor);
        super.visitChildren(elementVisitor);
    }

    @Override
    protected String getIdentifier() {
        return "AngularComponent@" + this.annotationOffset;
    }
}

