/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.type.Type;

public abstract class VariableElementImpl
extends ElementImpl
implements VariableElement {
    private Type type;
    private FunctionElement initializer;
    public static final VariableElement[] EMPTY_ARRAY = new VariableElement[0];

    public VariableElementImpl(Identifier identifier) {
        super(identifier);
    }

    public VariableElementImpl(String string, int n) {
        super(string, n);
    }

    public EvaluationResultImpl getEvaluationResult() {
        return null;
    }

    @Override
    public FunctionElement getInitializer() {
        return this.initializer;
    }

    @Override
    public VariableDeclaration getNode() throws AnalysisException {
        return this.getNodeMatching(VariableDeclaration.class);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isConst() {
        return this.hasModifier(Modifier.CONST);
    }

    @Override
    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public boolean isPotentiallyMutatedInClosure() {
        return false;
    }

    public boolean isPotentiallyMutatedInScope() {
        return false;
    }

    public void setConst(boolean bl) {
        this.setModifier(Modifier.CONST, bl);
    }

    public void setEvaluationResult(EvaluationResultImpl evaluationResultImpl) {
        throw new IllegalStateException("Invalid attempt to set a compile-time constant result");
    }

    public void setFinal(boolean bl) {
        this.setModifier(Modifier.FINAL, bl);
    }

    public void setInitializer(FunctionElement functionElement) {
        if (functionElement != null) {
            ((FunctionElementImpl)functionElement).setEnclosingElement(this);
        }
        this.initializer = functionElement;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChild(this.initializer, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.getType());
        stringBuilder.append(" ");
        stringBuilder.append(this.getDisplayName());
    }
}

