/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.PropertyInducingElement;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.internal.element.PropertyInducingElementImpl;
import com.google.dart.engine.utilities.general.ObjectUtilities;

public class PropertyAccessorElementImpl
extends ExecutableElementImpl
implements PropertyAccessorElement {
    private PropertyInducingElement variable;
    public static final PropertyAccessorElement[] EMPTY_ARRAY = new PropertyAccessorElement[0];

    public PropertyAccessorElementImpl(Identifier identifier) {
        super(identifier);
    }

    public PropertyAccessorElementImpl(PropertyInducingElementImpl propertyInducingElementImpl) {
        super(propertyInducingElementImpl.getName(), propertyInducingElementImpl.getNameOffset());
        this.variable = propertyInducingElementImpl;
        this.setSynthetic(true);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitPropertyAccessorElement(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.isGetter() == ((PropertyAccessorElement)object).isGetter();
    }

    @Override
    public PropertyAccessorElement getCorrespondingGetter() {
        if (this.isGetter() || this.variable == null) {
            return null;
        }
        return this.variable.getGetter();
    }

    @Override
    public PropertyAccessorElement getCorrespondingSetter() {
        if (this.isSetter() || this.variable == null) {
            return null;
        }
        return this.variable.getSetter();
    }

    @Override
    public ElementKind getKind() {
        if (this.isGetter()) {
            return ElementKind.GETTER;
        }
        return ElementKind.SETTER;
    }

    @Override
    public String getName() {
        if (this.isSetter()) {
            return super.getName() + '=';
        }
        return super.getName();
    }

    @Override
    public AstNode getNode() throws AnalysisException {
        if (this.isSynthetic()) {
            return null;
        }
        if (this.getEnclosingElement() instanceof ClassElement) {
            return this.getNodeMatching(MethodDeclaration.class);
        }
        if (this.getEnclosingElement() instanceof CompilationUnitElement) {
            return this.getNodeMatching(FunctionDeclaration.class);
        }
        return null;
    }

    @Override
    public PropertyInducingElement getVariable() {
        return this.variable;
    }

    @Override
    public int hashCode() {
        return ObjectUtilities.combineHashCodes(super.hashCode(), this.isGetter() ? 1 : 2);
    }

    @Override
    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    @Override
    public boolean isGetter() {
        return this.hasModifier(Modifier.GETTER);
    }

    @Override
    public boolean isSetter() {
        return this.hasModifier(Modifier.SETTER);
    }

    @Override
    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public void setAbstract(boolean bl) {
        this.setModifier(Modifier.ABSTRACT, bl);
    }

    public void setGetter(boolean bl) {
        this.setModifier(Modifier.GETTER, bl);
    }

    public void setSetter(boolean bl) {
        this.setModifier(Modifier.SETTER, bl);
    }

    public void setStatic(boolean bl) {
        this.setModifier(Modifier.STATIC, bl);
    }

    public void setVariable(PropertyInducingElement propertyInducingElement) {
        this.variable = propertyInducingElement;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.isGetter() ? "get " : "set ");
        stringBuilder.append(this.getVariable().getDisplayName());
        super.appendTo(stringBuilder);
    }
}

