/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.utilities.dart.ParameterKind;
import com.google.dart.engine.utilities.source.SourceRange;

public class ParameterElementImpl
extends VariableElementImpl
implements ParameterElement {
    private boolean potentiallyMutatedInScope;
    private boolean potentiallyMutatedInClosure;
    private ParameterElement[] parameters = EMPTY_ARRAY;
    private ParameterKind parameterKind;
    private int defaultValueRangeOffset;
    private int defaultValueRangeLength = -1;
    private int visibleRangeOffset;
    private int visibleRangeLength = -1;
    public static final ParameterElement[] EMPTY_ARRAY = new ParameterElement[0];

    public ParameterElementImpl(Identifier identifier) {
        super(identifier);
    }

    public ParameterElementImpl(String string, int n) {
        super(string, n);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitParameterElement(this);
    }

    @Override
    public SourceRange getDefaultValueRange() {
        if (this.defaultValueRangeLength < 0) {
            return null;
        }
        return new SourceRange(this.defaultValueRangeOffset, this.defaultValueRangeLength);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.PARAMETER;
    }

    @Override
    public ParameterKind getParameterKind() {
        return this.parameterKind;
    }

    @Override
    public ParameterElement[] getParameters() {
        return this.parameters;
    }

    @Override
    public SourceRange getVisibleRange() {
        if (this.visibleRangeLength < 0) {
            return null;
        }
        return new SourceRange(this.visibleRangeOffset, this.visibleRangeLength);
    }

    @Override
    public boolean isInitializingFormal() {
        return false;
    }

    @Override
    public boolean isPotentiallyMutatedInClosure() {
        return this.potentiallyMutatedInClosure;
    }

    @Override
    public boolean isPotentiallyMutatedInScope() {
        return this.potentiallyMutatedInScope;
    }

    public void markPotentiallyMutatedInClosure() {
        this.potentiallyMutatedInClosure = true;
    }

    public void markPotentiallyMutatedInScope() {
        this.potentiallyMutatedInScope = true;
    }

    public void setDefaultValueRange(int n, int n2) {
        this.defaultValueRangeOffset = n;
        this.defaultValueRangeLength = n2;
    }

    public void setParameterKind(ParameterKind parameterKind) {
        this.parameterKind = parameterKind;
    }

    public void setParameters(ParameterElement[] parameterElementArray) {
        for (ParameterElement parameterElement : parameterElementArray) {
            ((ParameterElementImpl)parameterElement).setEnclosingElement(this);
        }
        this.parameters = parameterElementArray;
    }

    public void setVisibleRange(int n, int n2) {
        this.visibleRangeOffset = n;
        this.visibleRangeLength = n2;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.parameters, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        String string = "";
        String string2 = "";
        switch (this.getParameterKind()) {
            case NAMED: {
                string = "{";
                string2 = "}";
                break;
            }
            case POSITIONAL: {
                string = "[";
                string2 = "]";
                break;
            }
        }
        stringBuilder.append(string);
        this.appendToWithoutDelimiters(stringBuilder);
        stringBuilder.append(string2);
    }

    protected void appendToWithoutDelimiters(StringBuilder stringBuilder) {
        stringBuilder.append(this.getType());
        stringBuilder.append(" ");
        stringBuilder.append(this.getDisplayName());
    }
}

