/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MultiplyDefinedElement;
import com.google.dart.engine.internal.element.ElementAnnotationImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.Type;
import java.util.HashSet;

public class MultiplyDefinedElementImpl
implements MultiplyDefinedElement {
    private AnalysisContext context;
    private String name;
    private Element[] conflictingElements;

    public static Element fromElements(AnalysisContext analysisContext, Element element, Element element2) {
        Element[] elementArray = MultiplyDefinedElementImpl.computeConflictingElements(element, element2);
        int n = elementArray.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return elementArray[0];
        }
        return new MultiplyDefinedElementImpl(analysisContext, elementArray);
    }

    private static void add(HashSet<Element> hashSet, Element element) {
        if (element instanceof MultiplyDefinedElementImpl) {
            for (Element element2 : ((MultiplyDefinedElementImpl)element).conflictingElements) {
                hashSet.add(element2);
            }
        } else {
            hashSet.add(element);
        }
    }

    private static Element[] computeConflictingElements(Element element, Element element2) {
        HashSet<Element> hashSet = new HashSet<Element>();
        MultiplyDefinedElementImpl.add(hashSet, element);
        MultiplyDefinedElementImpl.add(hashSet, element2);
        return hashSet.toArray(new Element[hashSet.size()]);
    }

    public MultiplyDefinedElementImpl(AnalysisContext analysisContext, Element[] elementArray) {
        this.context = analysisContext;
        this.name = elementArray[0].getName();
        this.conflictingElements = elementArray;
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitMultiplyDefinedElement(this);
    }

    @Override
    public String computeDocumentationComment() throws AnalysisException {
        return null;
    }

    @Override
    public <E extends Element> E getAncestor(Class<E> clazz) {
        return null;
    }

    @Override
    public Element[] getConflictingElements() {
        return this.conflictingElements;
    }

    @Override
    public AnalysisContext getContext() {
        return this.context;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public Element getEnclosingElement() {
        return null;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.ERROR;
    }

    @Override
    public LibraryElement getLibrary() {
        return null;
    }

    @Override
    public ElementLocation getLocation() {
        return null;
    }

    @Override
    public ElementAnnotation[] getMetadata() {
        return ElementAnnotationImpl.EMPTY_ARRAY;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNameOffset() {
        return -1;
    }

    @Override
    public AstNode getNode() throws AnalysisException {
        return null;
    }

    @Override
    public Source getSource() {
        return null;
    }

    @Override
    public Type getType() {
        return DynamicTypeImpl.getInstance();
    }

    @Override
    public CompilationUnit getUnit() throws AnalysisException {
        return null;
    }

    @Override
    public boolean isAccessibleIn(LibraryElement libraryElement) {
        for (Element element : this.conflictingElements) {
            if (!element.isAccessibleIn(libraryElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isOverride() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        String string = this.getDisplayName();
        if (string == null) {
            return false;
        }
        return Identifier.isPrivateName(string);
    }

    @Override
    public boolean isPublic() {
        return !this.isPrivate();
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = this.conflictingElements.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ((ElementImpl)this.conflictingElements[i]).appendTo(stringBuilder);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
    }
}

