/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.Modifier;

public class MethodElementImpl
extends ExecutableElementImpl
implements MethodElement {
    public static final MethodElement[] EMPTY_ARRAY = new MethodElement[0];

    public MethodElementImpl(Identifier identifier) {
        super(identifier);
    }

    public MethodElementImpl(String string, int n) {
        super(string, n);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitMethodElement(this);
    }

    @Override
    public ClassElement getEnclosingElement() {
        return (ClassElement)super.getEnclosingElement();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.METHOD;
    }

    @Override
    public String getName() {
        String string = super.getName();
        if (this.isOperator() && string.equals("-") && this.getParameters().length == 0) {
            return "unary-";
        }
        return super.getName();
    }

    @Override
    public MethodDeclaration getNode() throws AnalysisException {
        return this.getNodeMatching(MethodDeclaration.class);
    }

    @Override
    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    @Override
    public boolean isOperator() {
        String string = this.getDisplayName();
        if (string.isEmpty()) {
            return false;
        }
        char c = string.charAt(0);
        return !('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_' || c == '$');
    }

    @Override
    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public void setAbstract(boolean bl) {
        this.setModifier(Modifier.ABSTRACT, bl);
    }

    public void setStatic(boolean bl) {
        this.setModifier(Modifier.STATIC, bl);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.getEnclosingElement().getDisplayName());
        stringBuilder.append(".");
        stringBuilder.append(this.getDisplayName());
        super.appendTo(stringBuilder);
    }
}

