/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.internal.element.CompilationUnitElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.utilities.source.SourceRange;

public class LocalVariableElementImpl
extends VariableElementImpl
implements LocalVariableElement {
    private boolean potentiallyMutatedInScope;
    private boolean potentiallyMutatedInClosure;
    private int visibleRangeOffset;
    private int visibleRangeLength = -1;
    public static final LocalVariableElement[] EMPTY_ARRAY = new LocalVariableElement[0];

    public LocalVariableElementImpl(Identifier identifier) {
        super(identifier);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitLocalVariableElement(this);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.LOCAL_VARIABLE;
    }

    @Override
    public ToolkitObjectElement[] getToolkitObjects() {
        CompilationUnitElementImpl compilationUnitElementImpl = this.getAncestor(CompilationUnitElementImpl.class);
        if (compilationUnitElementImpl == null) {
            return ToolkitObjectElement.EMPTY_ARRAY;
        }
        return compilationUnitElementImpl.getToolkitObjects(this);
    }

    @Override
    public SourceRange getVisibleRange() {
        if (this.visibleRangeLength < 0) {
            return null;
        }
        return new SourceRange(this.visibleRangeOffset, this.visibleRangeLength);
    }

    @Override
    public boolean isPotentiallyMutatedInClosure() {
        return this.potentiallyMutatedInClosure;
    }

    @Override
    public boolean isPotentiallyMutatedInScope() {
        return this.potentiallyMutatedInScope;
    }

    public void markPotentiallyMutatedInClosure() {
        this.potentiallyMutatedInClosure = true;
    }

    public void markPotentiallyMutatedInScope() {
        this.potentiallyMutatedInScope = true;
    }

    public void setToolkitObjects(ToolkitObjectElement[] toolkitObjectElementArray) {
        CompilationUnitElementImpl compilationUnitElementImpl = this.getAncestor(CompilationUnitElementImpl.class);
        if (compilationUnitElementImpl == null) {
            return;
        }
        compilationUnitElementImpl.setToolkitObjects(this, toolkitObjectElementArray);
    }

    public void setVisibleRange(int n, int n2) {
        this.visibleRangeOffset = n;
        this.visibleRangeLength = n2;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.getType());
        stringBuilder.append(" ");
        stringBuilder.append(this.getDisplayName());
    }

    @Override
    protected String getIdentifier() {
        return super.getIdentifier() + "@" + this.getNameOffset();
    }
}

