/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.common.collect.Sets;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.UriReferencedElement;
import com.google.dart.engine.internal.element.CompilationUnitElementImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.ExportElementImpl;
import com.google.dart.engine.internal.element.ImportElementImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.internal.element.PrefixElementImpl;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LibraryElementImpl
extends ElementImpl
implements LibraryElement {
    public static final LibraryElement[] EMPTY_ARRAY = new LibraryElement[0];
    private AnalysisContext context;
    private CompilationUnitElement definingCompilationUnit;
    private FunctionElement entryPoint;
    private ImportElement[] imports = ImportElement.EMPTY_ARRAY;
    private ExportElement[] exports = ExportElement.EMPTY_ARRAY;
    private CompilationUnitElement[] parts = CompilationUnitElementImpl.EMPTY_ARRAY;
    private boolean isAngularHtml;

    private static boolean safeIsUpToDate(LibraryElement libraryElement, long l, Set<LibraryElement> set) {
        if (!set.contains(libraryElement)) {
            set.add(libraryElement);
            AnalysisContext analysisContext = libraryElement.getContext();
            if (l < analysisContext.getModificationStamp(libraryElement.getDefiningCompilationUnit().getSource())) {
                return false;
            }
            for (CompilationUnitElement element : libraryElement.getParts()) {
                if (l >= analysisContext.getModificationStamp(element.getSource())) continue;
                return false;
            }
            for (Element element : libraryElement.getImportedLibraries()) {
                if (LibraryElementImpl.safeIsUpToDate((LibraryElement)element, l, set)) continue;
                return false;
            }
            for (Element element : libraryElement.getExportedLibraries()) {
                if (LibraryElementImpl.safeIsUpToDate((LibraryElement)element, l, set)) continue;
                return false;
            }
        }
        return true;
    }

    public LibraryElementImpl(AnalysisContext analysisContext, LibraryIdentifier libraryIdentifier) {
        super(libraryIdentifier);
        this.context = analysisContext;
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitLibraryElement(this);
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.definingCompilationUnit.equals(((LibraryElementImpl)object).getDefiningCompilationUnit());
    }

    @Override
    public ElementImpl getChild(String string) {
        if (((CompilationUnitElementImpl)this.definingCompilationUnit).getIdentifier().equals(string)) {
            return (CompilationUnitElementImpl)this.definingCompilationUnit;
        }
        for (CompilationUnitElement uriReferencedElement : this.parts) {
            if (!((CompilationUnitElementImpl)uriReferencedElement).getIdentifier().equals(string)) continue;
            return (CompilationUnitElementImpl)uriReferencedElement;
        }
        for (UriReferencedElement uriReferencedElement : this.imports) {
            if (!((ImportElementImpl)uriReferencedElement).getIdentifier().equals(string)) continue;
            return (ImportElementImpl)uriReferencedElement;
        }
        for (UriReferencedElement uriReferencedElement : this.exports) {
            if (!((ExportElementImpl)uriReferencedElement).getIdentifier().equals(string)) continue;
            return (ExportElementImpl)uriReferencedElement;
        }
        return null;
    }

    @Override
    public AnalysisContext getContext() {
        return this.context;
    }

    @Override
    public CompilationUnitElement getDefiningCompilationUnit() {
        return this.definingCompilationUnit;
    }

    @Override
    public FunctionElement getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public LibraryElement[] getExportedLibraries() {
        HashSet<LibraryElement> hashSet = new HashSet<LibraryElement>(this.exports.length);
        for (ExportElement exportElement : this.exports) {
            LibraryElement libraryElement = exportElement.getExportedLibrary();
            if (libraryElement == null) continue;
            hashSet.add(libraryElement);
        }
        return hashSet.toArray(new LibraryElement[hashSet.size()]);
    }

    @Override
    public ExportElement[] getExports() {
        return this.exports;
    }

    @Override
    public LibraryElement[] getImportedLibraries() {
        HashSet<LibraryElement> hashSet = new HashSet<LibraryElement>(this.imports.length);
        for (ImportElement importElement : this.imports) {
            LibraryElement libraryElement = importElement.getImportedLibrary();
            if (libraryElement == null) continue;
            hashSet.add(libraryElement);
        }
        return hashSet.toArray(new LibraryElement[hashSet.size()]);
    }

    @Override
    public ImportElement[] getImports() {
        return this.imports;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.LIBRARY;
    }

    @Override
    public LibraryElement getLibrary() {
        return this;
    }

    @Override
    public CompilationUnitElement[] getParts() {
        return this.parts;
    }

    @Override
    public PrefixElement[] getPrefixes() {
        HashSet<PrefixElement> hashSet = new HashSet<PrefixElement>(this.imports.length);
        for (ImportElement importElement : this.imports) {
            PrefixElement prefixElement = importElement.getPrefix();
            if (prefixElement == null) continue;
            hashSet.add(prefixElement);
        }
        return hashSet.toArray(new PrefixElement[hashSet.size()]);
    }

    @Override
    public Source getSource() {
        if (this.definingCompilationUnit == null) {
            return null;
        }
        return this.definingCompilationUnit.getSource();
    }

    @Override
    public ClassElement getType(String string) {
        ClassElement classElement = this.definingCompilationUnit.getType(string);
        if (classElement != null) {
            return classElement;
        }
        for (CompilationUnitElement compilationUnitElement : this.parts) {
            classElement = compilationUnitElement.getType(string);
            if (classElement == null) continue;
            return classElement;
        }
        return null;
    }

    @Override
    public CompilationUnitElement[] getUnits() {
        CompilationUnitElement[] compilationUnitElementArray = new CompilationUnitElement[1 + this.parts.length];
        compilationUnitElementArray[0] = this.definingCompilationUnit;
        System.arraycopy(this.parts, 0, compilationUnitElementArray, 1, this.parts.length);
        return compilationUnitElementArray;
    }

    @Override
    public LibraryElement[] getVisibleLibraries() {
        HashSet<LibraryElement> hashSet = Sets.newHashSet();
        this.addVisibleLibraries(hashSet, false);
        return hashSet.toArray(new LibraryElement[hashSet.size()]);
    }

    @Override
    public boolean hasExtUri() {
        return this.hasModifier(Modifier.HAS_EXT_URI);
    }

    @Override
    public int hashCode() {
        return this.definingCompilationUnit.hashCode();
    }

    @Override
    public boolean isAngularHtml() {
        return this.isAngularHtml;
    }

    @Override
    public boolean isBrowserApplication() {
        return this.entryPoint != null && this.isOrImportsBrowserLibrary();
    }

    @Override
    public boolean isDartCore() {
        return this.getName().equals("dart.core");
    }

    @Override
    public boolean isInSdk() {
        return StringUtilities.startsWith5(this.getName(), 0, 100, 97, 114, 116, 46);
    }

    @Override
    public boolean isUpToDate(long l) {
        HashSet<LibraryElement> hashSet = Sets.newHashSet();
        return LibraryElementImpl.safeIsUpToDate(this, l, hashSet);
    }

    public void setAngularHtml(boolean bl) {
        this.isAngularHtml = bl;
    }

    public void setDefiningCompilationUnit(CompilationUnitElement compilationUnitElement) {
        ((CompilationUnitElementImpl)compilationUnitElement).setEnclosingElement(this);
        this.definingCompilationUnit = compilationUnitElement;
    }

    public void setEntryPoint(FunctionElement functionElement) {
        this.entryPoint = functionElement;
    }

    public void setExports(ExportElement[] exportElementArray) {
        for (ExportElement exportElement : exportElementArray) {
            ((ExportElementImpl)exportElement).setEnclosingElement(this);
        }
        this.exports = exportElementArray;
    }

    public void setHasExtUri(boolean bl) {
        this.setModifier(Modifier.HAS_EXT_URI, bl);
    }

    public void setImports(ImportElement[] importElementArray) {
        for (ImportElement importElement : importElementArray) {
            ((ImportElementImpl)importElement).setEnclosingElement(this);
            PrefixElementImpl prefixElementImpl = (PrefixElementImpl)importElement.getPrefix();
            if (prefixElementImpl == null) continue;
            prefixElementImpl.setEnclosingElement(this);
        }
        this.imports = importElementArray;
    }

    public void setParts(CompilationUnitElement[] compilationUnitElementArray) {
        for (CompilationUnitElement compilationUnitElement : compilationUnitElementArray) {
            ((CompilationUnitElementImpl)compilationUnitElement).setEnclosingElement(this);
        }
        this.parts = compilationUnitElementArray;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChild(this.definingCompilationUnit, elementVisitor);
        this.safelyVisitChildren(this.exports, elementVisitor);
        this.safelyVisitChildren(this.imports, elementVisitor);
        this.safelyVisitChildren(this.parts, elementVisitor);
    }

    @Override
    protected String getIdentifier() {
        return this.definingCompilationUnit.getSource().getEncoding();
    }

    private void addVisibleLibraries(Set<LibraryElement> set, boolean bl) {
        LibraryElement libraryElement;
        if (!set.add(this)) {
            return;
        }
        for (ImportElement uriReferencedElement : this.imports) {
            libraryElement = uriReferencedElement.getImportedLibrary();
            if (libraryElement == null) continue;
            ((LibraryElementImpl)libraryElement).addVisibleLibraries(set, true);
        }
        if (bl) {
            for (UriReferencedElement uriReferencedElement : this.exports) {
                libraryElement = uriReferencedElement.getExportedLibrary();
                if (libraryElement == null) continue;
                ((LibraryElementImpl)libraryElement).addVisibleLibraries(set, true);
            }
        }
    }

    private boolean isOrImportsBrowserLibrary() {
        ArrayList<LibraryElement> arrayList = new ArrayList<LibraryElement>(10);
        Source source = this.context.getSourceFactory().forUri("dart:html");
        arrayList.add(this);
        for (int i = 0; i < arrayList.size(); ++i) {
            LibraryElement libraryElement = (LibraryElement)arrayList.get(i);
            Source source2 = libraryElement.getDefiningCompilationUnit().getSource();
            if (((Object)source2).equals(source)) {
                return true;
            }
            for (LibraryElement libraryElement2 : libraryElement.getImportedLibraries()) {
                if (arrayList.contains(libraryElement2)) continue;
                arrayList.add(libraryElement2);
            }
            for (LibraryElement libraryElement2 : libraryElement.getExportedLibraries()) {
                if (arrayList.contains(libraryElement2)) continue;
                arrayList.add(libraryElement2);
            }
        }
        return false;
    }
}

