/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ImportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.NamespaceCombinator;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.UriReferencedElementImpl;

public class ImportElementImpl
extends UriReferencedElementImpl
implements ImportElement {
    private int prefixOffset;
    private LibraryElement importedLibrary;
    private NamespaceCombinator[] combinators = NamespaceCombinator.EMPTY_ARRAY;
    private PrefixElement prefix;

    public ImportElementImpl(int n) {
        super(null, n);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitImportElement(this);
    }

    @Override
    public NamespaceCombinator[] getCombinators() {
        return this.combinators;
    }

    @Override
    public LibraryElement getImportedLibrary() {
        return this.importedLibrary;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.IMPORT;
    }

    @Override
    public PrefixElement getPrefix() {
        return this.prefix;
    }

    @Override
    public int getPrefixOffset() {
        return this.prefixOffset;
    }

    public void setCombinators(NamespaceCombinator[] namespaceCombinatorArray) {
        this.combinators = namespaceCombinatorArray;
    }

    public void setImportedLibrary(LibraryElement libraryElement) {
        this.importedLibrary = libraryElement;
    }

    public void setPrefix(PrefixElement prefixElement) {
        this.prefix = prefixElement;
    }

    public void setPrefixOffset(int n) {
        this.prefixOffset = n;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChild(this.prefix, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("import ");
        ((LibraryElementImpl)this.importedLibrary).appendTo(stringBuilder);
    }

    @Override
    protected String getIdentifier() {
        return ((LibraryElementImpl)this.importedLibrary).getIdentifier() + "@" + this.getNameOffset();
    }
}

