/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.HtmlScriptElement;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.HtmlScriptElementImpl;
import com.google.dart.engine.source.Source;

public class HtmlElementImpl
extends ElementImpl
implements HtmlElement {
    public static final HtmlElement[] EMPTY_ARRAY = new HtmlElement[0];
    private AnalysisContext context;
    private HtmlScriptElement[] scripts = HtmlScriptElementImpl.EMPTY_ARRAY;
    private Source source;
    private CompilationUnitElement angularCompilationUnit;

    public HtmlElementImpl(AnalysisContext analysisContext, String string) {
        super(string, -1);
        this.context = analysisContext;
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitHtmlElement(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass() && ((Object)this.source).equals(((HtmlElementImpl)object).getSource());
    }

    @Override
    public CompilationUnitElement getAngularCompilationUnit() {
        return this.angularCompilationUnit;
    }

    @Override
    public AnalysisContext getContext() {
        return this.context;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.HTML;
    }

    @Override
    public HtmlScriptElement[] getScripts() {
        return this.scripts;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int hashCode() {
        return ((Object)this.source).hashCode();
    }

    public void setAngularCompilationUnit(CompilationUnitElement compilationUnitElement) {
        this.angularCompilationUnit = compilationUnitElement;
    }

    public void setScripts(HtmlScriptElement[] htmlScriptElementArray) {
        if (htmlScriptElementArray.length == 0) {
            htmlScriptElementArray = HtmlScriptElementImpl.EMPTY_ARRAY;
        }
        for (HtmlScriptElement htmlScriptElement : htmlScriptElementArray) {
            ((HtmlScriptElementImpl)htmlScriptElement).setEnclosingElement(this);
        }
        this.scripts = htmlScriptElementArray;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.scripts, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        if (this.source == null) {
            stringBuilder.append("{HTML file}");
        } else {
            stringBuilder.append(this.source.getFullName());
        }
    }
}

