/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.Type;

public class FunctionTypeAliasElementImpl
extends ElementImpl
implements FunctionTypeAliasElement {
    private ParameterElement[] parameters = ParameterElementImpl.EMPTY_ARRAY;
    private Type returnType;
    private FunctionType type;
    private TypeParameterElement[] typeParameters = TypeParameterElementImpl.EMPTY_ARRAY;
    public static final FunctionTypeAliasElement[] EMPTY_ARRAY = new FunctionTypeAliasElement[0];

    public FunctionTypeAliasElementImpl(Identifier identifier) {
        super(identifier);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitFunctionTypeAliasElement(this);
    }

    @Override
    public ElementImpl getChild(String string) {
        for (ParameterElement element : this.parameters) {
            if (!((VariableElementImpl)((Object)element)).getIdentifier().equals(string)) continue;
            return (VariableElementImpl)((Object)element);
        }
        for (Element element : this.typeParameters) {
            if (!((TypeParameterElementImpl)element).getIdentifier().equals(string)) continue;
            return (TypeParameterElementImpl)element;
        }
        return null;
    }

    @Override
    public CompilationUnitElement getEnclosingElement() {
        return (CompilationUnitElement)super.getEnclosingElement();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FUNCTION_TYPE_ALIAS;
    }

    @Override
    public FunctionTypeAlias getNode() throws AnalysisException {
        return this.getNodeMatching(FunctionTypeAlias.class);
    }

    @Override
    public ParameterElement[] getParameters() {
        return this.parameters;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public FunctionType getType() {
        return this.type;
    }

    @Override
    public TypeParameterElement[] getTypeParameters() {
        return this.typeParameters;
    }

    public void setParameters(ParameterElement[] parameterElementArray) {
        if (parameterElementArray != null) {
            for (ParameterElement parameterElement : parameterElementArray) {
                ((ParameterElementImpl)parameterElement).setEnclosingElement(this);
            }
        }
        this.parameters = parameterElementArray;
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public void setType(FunctionType functionType) {
        this.type = functionType;
    }

    public void setTypeParameters(TypeParameterElement[] typeParameterElementArray) {
        for (TypeParameterElement typeParameterElement : typeParameterElementArray) {
            ((TypeParameterElementImpl)typeParameterElement).setEnclosingElement(this);
        }
        this.typeParameters = typeParameterElementArray;
    }

    public void shareParameters(ParameterElement[] parameterElementArray) {
        this.parameters = parameterElementArray;
    }

    public void shareTypeParameters(TypeParameterElement[] typeParameterElementArray) {
        this.typeParameters = typeParameterElementArray;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.parameters, elementVisitor);
        this.safelyVisitChildren(this.typeParameters, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        int n;
        stringBuilder.append("typedef ");
        stringBuilder.append(this.getDisplayName());
        int n2 = this.typeParameters.length;
        if (n2 > 0) {
            stringBuilder.append("<");
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                ((TypeParameterElementImpl)this.typeParameters[n]).appendTo(stringBuilder);
            }
            stringBuilder.append(">");
        }
        stringBuilder.append("(");
        n = this.parameters.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ((ParameterElementImpl)this.parameters[i]).appendTo(stringBuilder);
        }
        stringBuilder.append(")");
        if (this.type != null) {
            stringBuilder.append(" \u2192 ");
            stringBuilder.append(this.type.getReturnType());
        }
    }
}

