/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.utilities.source.SourceRange;

public class FunctionElementImpl
extends ExecutableElementImpl
implements FunctionElement {
    private int visibleRangeOffset;
    private int visibleRangeLength = -1;
    public static final FunctionElement[] EMPTY_ARRAY = new FunctionElement[0];

    public FunctionElementImpl(Identifier identifier) {
        super(identifier);
    }

    public FunctionElementImpl(int n) {
        super("", n);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitFunctionElement(this);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FUNCTION;
    }

    @Override
    public FunctionDeclaration getNode() throws AnalysisException {
        return this.getNodeMatching(FunctionDeclaration.class);
    }

    @Override
    public SourceRange getVisibleRange() {
        if (this.visibleRangeLength < 0) {
            return null;
        }
        return new SourceRange(this.visibleRangeOffset, this.visibleRangeLength);
    }

    @Override
    public boolean isStatic() {
        return this.getEnclosingElement() instanceof CompilationUnitElement;
    }

    public void setVisibleRange(int n, int n2) {
        this.visibleRangeOffset = n;
        this.visibleRangeLength = n2;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        String string = this.getDisplayName();
        if (string != null) {
            stringBuilder.append(string);
        }
        super.appendTo(stringBuilder);
    }

    @Override
    protected String getIdentifier() {
        return this.getName() + "@" + this.getNameOffset();
    }
}

