/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExportElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.NamespaceCombinator;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.UriReferencedElementImpl;

public class ExportElementImpl
extends UriReferencedElementImpl
implements ExportElement {
    private LibraryElement exportedLibrary;
    private NamespaceCombinator[] combinators = NamespaceCombinator.EMPTY_ARRAY;

    public ExportElementImpl() {
        super(null, -1);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitExportElement(this);
    }

    @Override
    public NamespaceCombinator[] getCombinators() {
        return this.combinators;
    }

    @Override
    public LibraryElement getExportedLibrary() {
        return this.exportedLibrary;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.EXPORT;
    }

    public void setCombinators(NamespaceCombinator[] namespaceCombinatorArray) {
        this.combinators = namespaceCombinatorArray;
    }

    public void setExportedLibrary(LibraryElement libraryElement) {
        this.exportedLibrary = libraryElement;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("export ");
        ((LibraryElementImpl)this.exportedLibrary).appendTo(stringBuilder);
    }

    @Override
    protected String getIdentifier() {
        return this.exportedLibrary.getName();
    }
}

