/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.LabelElementImpl;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.dart.ParameterKind;

public abstract class ExecutableElementImpl
extends ElementImpl
implements ExecutableElement {
    private FunctionElement[] functions = FunctionElementImpl.EMPTY_ARRAY;
    private LabelElement[] labels = LabelElementImpl.EMPTY_ARRAY;
    private LocalVariableElement[] localVariables = LocalVariableElementImpl.EMPTY_ARRAY;
    private ParameterElement[] parameters = ParameterElementImpl.EMPTY_ARRAY;
    private Type returnType;
    private FunctionType type;
    public static final ExecutableElement[] EMPTY_ARRAY = new ExecutableElement[0];

    public ExecutableElementImpl(Identifier identifier) {
        super(identifier);
    }

    public ExecutableElementImpl(String string, int n) {
        super(string, n);
    }

    @Override
    public ElementImpl getChild(String string) {
        for (FunctionElement element : this.functions) {
            if (!((ExecutableElementImpl)((Object)element)).getIdentifier().equals(string)) continue;
            return (ExecutableElementImpl)((Object)element);
        }
        for (Element element : this.labels) {
            if (!((LabelElementImpl)element).getIdentifier().equals(string)) continue;
            return (LabelElementImpl)element;
        }
        for (Element element : this.localVariables) {
            if (!((VariableElementImpl)element).getIdentifier().equals(string)) continue;
            return (VariableElementImpl)element;
        }
        for (Element element : this.parameters) {
            if (!((ParameterElementImpl)element).getIdentifier().equals(string)) continue;
            return (ParameterElementImpl)element;
        }
        return null;
    }

    @Override
    public FunctionElement[] getFunctions() {
        return this.functions;
    }

    @Override
    public LabelElement[] getLabels() {
        return this.labels;
    }

    @Override
    public LocalVariableElement[] getLocalVariables() {
        return this.localVariables;
    }

    @Override
    public ParameterElement[] getParameters() {
        return this.parameters;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public FunctionType getType() {
        return this.type;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    public void setFunctions(FunctionElement[] functionElementArray) {
        for (FunctionElement functionElement : functionElementArray) {
            ((FunctionElementImpl)functionElement).setEnclosingElement(this);
        }
        this.functions = functionElementArray;
    }

    public void setLabels(LabelElement[] labelElementArray) {
        for (LabelElement labelElement : labelElementArray) {
            ((LabelElementImpl)labelElement).setEnclosingElement(this);
        }
        this.labels = labelElementArray;
    }

    public void setLocalVariables(LocalVariableElement[] localVariableElementArray) {
        for (LocalVariableElement localVariableElement : localVariableElementArray) {
            ((LocalVariableElementImpl)localVariableElement).setEnclosingElement(this);
        }
        this.localVariables = localVariableElementArray;
    }

    public void setParameters(ParameterElement[] parameterElementArray) {
        for (ParameterElement parameterElement : parameterElementArray) {
            ((ParameterElementImpl)parameterElement).setEnclosingElement(this);
        }
        this.parameters = parameterElementArray;
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public void setType(FunctionType functionType) {
        this.type = functionType;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.functions, elementVisitor);
        this.safelyVisitChildren(this.labels, elementVisitor);
        this.safelyVisitChildren(this.localVariables, elementVisitor);
        this.safelyVisitChildren(this.parameters, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        if (this.getKind() != ElementKind.GETTER) {
            stringBuilder.append("(");
            String string = null;
            ParameterKind parameterKind = ParameterKind.REQUIRED;
            int n = this.parameters.length;
            for (int i = 0; i < n; ++i) {
                ParameterElementImpl parameterElementImpl;
                ParameterKind parameterKind2;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if ((parameterKind2 = (parameterElementImpl = (ParameterElementImpl)this.parameters[i]).getParameterKind()) != parameterKind) {
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    if (parameterKind2 == ParameterKind.POSITIONAL) {
                        stringBuilder.append("[");
                        string = "]";
                    } else if (parameterKind2 == ParameterKind.NAMED) {
                        stringBuilder.append("{");
                        string = "}";
                    } else {
                        string = null;
                    }
                }
                parameterKind = parameterKind2;
                parameterElementImpl.appendToWithoutDelimiters(stringBuilder);
            }
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(")");
        }
        if (this.type != null) {
            stringBuilder.append(" \u2192 ");
            stringBuilder.append(this.type.getReturnType());
        }
    }
}

