/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.internal.element.ElementImpl;
import java.util.ArrayList;

public class ElementLocationImpl
implements ElementLocation {
    private String[] components;
    private static final char SEPARATOR_CHAR = ';';

    public ElementLocationImpl(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 = element; element2 != null; element2 = element2.getEnclosingElement()) {
            arrayList.add(0, ((ElementImpl)element2).getIdentifier());
        }
        this.components = arrayList.toArray(new String[arrayList.size()]);
    }

    public ElementLocationImpl(String string) {
        this.components = this.decode(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElementLocationImpl)) {
            return false;
        }
        ElementLocationImpl elementLocationImpl = (ElementLocationImpl)object;
        String[] stringArray = elementLocationImpl.components;
        int n = this.components.length;
        if (stringArray.length != n) {
            return false;
        }
        for (int i = n - 1; i >= 2; --i) {
            if (this.components[i].equals(stringArray[i])) continue;
            return false;
        }
        if (n > 1 && !this.equalSourceComponents(this.components[1], stringArray[1])) {
            return false;
        }
        return n <= 0 || this.equalSourceComponents(this.components[0], stringArray[0]);
    }

    public String[] getComponents() {
        return this.components;
    }

    @Override
    public String getEncoding() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            this.encode(stringBuilder, this.components[i]);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.components.length; ++i) {
            String string = this.components[i];
            int n2 = i <= 1 ? this.hashSourceComponent(string) : string.hashCode();
            n = 31 * n + n2;
        }
        return n;
    }

    public String toString() {
        return this.getEncoding();
    }

    private String[] decode(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == ';') {
                if (n + 1 < n2 && string.charAt(n + 1) == ';') {
                    stringBuilder.append(';');
                    n += 2;
                    continue;
                }
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                ++n;
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void encode(StringBuilder stringBuilder, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                stringBuilder.append(';');
            }
            stringBuilder.append(c);
        }
    }

    private boolean equalSourceComponents(String string, String string2) {
        int n;
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 != (n = string2.length())) {
            return false;
        }
        if (n2 <= 1 || n <= 1) {
            return string.equals(string2);
        }
        return string.regionMatches(1, string2, 1, n2 - 1);
    }

    private int hashSourceComponent(String string) {
        if (string.length() <= 1) {
            return string.hashCode();
        }
        return string.substring(1).hashCode();
    }
}

