/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.visitor.NodeLocator;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.internal.element.ElementAnnotationImpl;
import com.google.dart.engine.internal.element.ElementLocationImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.collection.BooleanArray;
import com.google.dart.engine.utilities.general.StringUtilities;
import com.google.dart.engine.utilities.translation.DartName;

public abstract class ElementImpl
implements Element {
    private ElementImpl enclosingElement;
    private final String name;
    private int nameOffset;
    private int modifiers;
    private ElementAnnotation[] metadata = ElementAnnotationImpl.EMPTY_ARRAY;
    private int cachedHashCode;

    @DartName(value="forNode")
    public ElementImpl(Identifier identifier) {
        this(identifier == null ? "" : identifier.getName(), identifier == null ? -1 : identifier.getOffset());
    }

    public ElementImpl(String string, int n) {
        this.name = StringUtilities.intern(string);
        this.nameOffset = n;
    }

    @Override
    public String computeDocumentationComment() throws AnalysisException {
        AnalysisContext analysisContext = this.getContext();
        if (analysisContext == null) {
            return null;
        }
        return analysisContext.computeDocumentationComment(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.hashCode() != object.hashCode()) {
            return false;
        }
        return object.getClass() == this.getClass() && ((Element)object).getLocation().equals(this.getLocation());
    }

    @Override
    public <E extends Element> E getAncestor(Class<E> clazz) {
        Element element;
        for (element = this.enclosingElement; element != null && !clazz.isInstance(element); element = element.getEnclosingElement()) {
        }
        return (E)element;
    }

    public ElementImpl getChild(String string) {
        return null;
    }

    @Override
    public AnalysisContext getContext() {
        if (this.enclosingElement == null) {
            return null;
        }
        return this.enclosingElement.getContext();
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public Element getEnclosingElement() {
        return this.enclosingElement;
    }

    @Override
    public LibraryElement getLibrary() {
        return this.getAncestor(LibraryElement.class);
    }

    @Override
    public ElementLocation getLocation() {
        return new ElementLocationImpl(this);
    }

    @Override
    public ElementAnnotation[] getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNameOffset() {
        return this.nameOffset;
    }

    @Override
    public AstNode getNode() throws AnalysisException {
        return this.getNodeMatching(AstNode.class);
    }

    @Override
    public Source getSource() {
        if (this.enclosingElement == null) {
            return null;
        }
        return this.enclosingElement.getSource();
    }

    @Override
    public CompilationUnit getUnit() throws AnalysisException {
        return this.getContext().resolveCompilationUnit(this.getSource(), this.getLibrary());
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int n = this.getIdentifier().hashCode();
            Element element = this.getEnclosingElement();
            this.cachedHashCode = element != null ? n + element.hashCode() : n;
        }
        return this.cachedHashCode;
    }

    @Override
    public boolean isAccessibleIn(LibraryElement libraryElement) {
        if (Identifier.isPrivateName(this.name)) {
            return libraryElement.equals(this.getLibrary());
        }
        return true;
    }

    @Override
    public boolean isDeprecated() {
        for (ElementAnnotation elementAnnotation : this.metadata) {
            if (!elementAnnotation.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOverride() {
        for (ElementAnnotation elementAnnotation : this.metadata) {
            if (!elementAnnotation.isOverride()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPrivate() {
        String string = this.getDisplayName();
        if (string == null) {
            return true;
        }
        return Identifier.isPrivateName(string);
    }

    @Override
    public boolean isPublic() {
        return !this.isPrivate();
    }

    @Override
    public boolean isSynthetic() {
        return this.hasModifier(Modifier.SYNTHETIC);
    }

    public void setMetadata(ElementAnnotation[] elementAnnotationArray) {
        this.metadata = elementAnnotationArray;
    }

    public void setNameOffset(int n) {
        this.nameOffset = n;
    }

    public void setSynthetic(boolean bl) {
        this.setModifier(Modifier.SYNTHETIC, bl);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
    }

    protected void appendTo(StringBuilder stringBuilder) {
        if (this.name == null) {
            stringBuilder.append("<unnamed ");
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append(">");
        } else {
            stringBuilder.append(this.name);
        }
    }

    protected void encloseElement(ElementImpl elementImpl) {
        elementImpl.setEnclosingElement(this);
    }

    protected String getIdentifier() {
        return this.getName();
    }

    protected <T extends AstNode> T getNodeMatching(Class<T> clazz) throws AnalysisException {
        CompilationUnit compilationUnit = this.getUnit();
        if (compilationUnit == null) {
            return null;
        }
        int n = this.getNameOffset();
        AstNode astNode = new NodeLocator(n).searchWithin(compilationUnit);
        if (astNode == null) {
            return null;
        }
        return astNode.getAncestor(clazz);
    }

    protected boolean hasModifier(Modifier modifier) {
        return BooleanArray.getEnum(this.modifiers, modifier);
    }

    protected void safelyVisitChild(Element element, ElementVisitor<?> elementVisitor) {
        if (element != null) {
            element.accept(elementVisitor);
        }
    }

    protected void safelyVisitChildren(Element[] elementArray, ElementVisitor<?> elementVisitor) {
        if (elementArray != null) {
            for (Element element : elementArray) {
                element.accept(elementVisitor);
            }
        }
    }

    protected void setEnclosingElement(Element element) {
        this.enclosingElement = (ElementImpl)element;
    }

    protected void setModifier(Modifier modifier, boolean bl) {
        this.modifiers = BooleanArray.setEnum(this.modifiers, modifier, bl);
    }
}

