/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.PropertyAccessorElement;

public class ElementAnnotationImpl
implements ElementAnnotation {
    private Element element;
    public static final ElementAnnotationImpl[] EMPTY_ARRAY = new ElementAnnotationImpl[0];
    private static final String DEPRECATED_CLASS_NAME = "Deprecated";
    private static final String DEPRECATED_VARIABLE_NAME = "deprecated";
    private static final String OVERRIDE_VARIABLE_NAME = "override";
    private static final String PROXY_VARIABLE_NAME = "proxy";

    public ElementAnnotationImpl(Element element) {
        this.element = element;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean isDeprecated() {
        ConstructorElement constructorElement;
        LibraryElement libraryElement;
        return this.element != null && (libraryElement = this.element.getLibrary()) != null && libraryElement.isDartCore() && (this.element instanceof ConstructorElement ? (constructorElement = (ConstructorElement)this.element).getEnclosingElement().getName().equals(DEPRECATED_CLASS_NAME) : this.element instanceof PropertyAccessorElement && this.element.getName().equals(DEPRECATED_VARIABLE_NAME));
    }

    @Override
    public boolean isOverride() {
        LibraryElement libraryElement;
        return this.element != null && (libraryElement = this.element.getLibrary()) != null && libraryElement.isDartCore() && this.element instanceof PropertyAccessorElement && this.element.getName().equals(OVERRIDE_VARIABLE_NAME);
    }

    @Override
    public boolean isProxy() {
        LibraryElement libraryElement;
        return this.element != null && (libraryElement = this.element.getLibrary()) != null && libraryElement.isDartCore() && this.element instanceof PropertyAccessorElement && this.element.getName().equals(PROXY_VARIABLE_NAME);
    }

    public String toString() {
        return "@" + this.element.toString();
    }
}

