/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.utilities.dart.ParameterKind;

public class ConstructorElementImpl
extends ExecutableElementImpl
implements ConstructorElement {
    public static final ConstructorElement[] EMPTY_ARRAY = new ConstructorElement[0];
    private ConstructorElement redirectedConstructor;

    public ConstructorElementImpl(Identifier identifier) {
        super(identifier);
    }

    public ConstructorElementImpl(String string, int n) {
        super(string, n);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitConstructorElement(this);
    }

    @Override
    public ClassElement getEnclosingElement() {
        return (ClassElement)super.getEnclosingElement();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CONSTRUCTOR;
    }

    @Override
    public ConstructorDeclaration getNode() throws AnalysisException {
        return this.getNodeMatching(ConstructorDeclaration.class);
    }

    @Override
    public ConstructorElement getRedirectedConstructor() {
        return this.redirectedConstructor;
    }

    @Override
    public boolean isConst() {
        return this.hasModifier(Modifier.CONST);
    }

    @Override
    public boolean isDefaultConstructor() {
        String string = this.getName();
        if (string != null && string.length() != 0) {
            return false;
        }
        for (ParameterElement parameterElement : this.getParameters()) {
            if (parameterElement.getParameterKind() != ParameterKind.REQUIRED) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFactory() {
        return this.hasModifier(Modifier.FACTORY);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public void setConst(boolean bl) {
        this.setModifier(Modifier.CONST, bl);
    }

    public void setFactory(boolean bl) {
        this.setModifier(Modifier.FACTORY, bl);
    }

    public void setRedirectedConstructor(ConstructorElement constructorElement) {
        this.redirectedConstructor = constructorElement;
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.getEnclosingElement().getDisplayName());
        String string = this.getDisplayName();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(".");
            stringBuilder.append(string);
        }
        super.appendTo(stringBuilder);
    }
}

