/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.common.collect.Maps;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.element.TopLevelVariableElement;
import com.google.dart.engine.element.angular.AngularViewElement;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.FunctionTypeAliasElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.TopLevelVariableElementImpl;
import com.google.dart.engine.internal.element.UriReferencedElementImpl;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.element.angular.AngularViewElementImpl;
import com.google.dart.engine.source.Source;
import java.util.Map;

public class CompilationUnitElementImpl
extends UriReferencedElementImpl
implements CompilationUnitElement {
    public static final CompilationUnitElement[] EMPTY_ARRAY = new CompilationUnitElement[0];
    private Source source;
    private PropertyAccessorElement[] accessors = PropertyAccessorElementImpl.EMPTY_ARRAY;
    private FunctionElement[] functions = FunctionElementImpl.EMPTY_ARRAY;
    private Map<Element, ToolkitObjectElement[]> toolkitObjects = Maps.newHashMap();
    private FunctionTypeAliasElement[] typeAliases = FunctionTypeAliasElementImpl.EMPTY_ARRAY;
    private ClassElement[] types = ClassElementImpl.EMPTY_ARRAY;
    private TopLevelVariableElement[] variables = TopLevelVariableElementImpl.EMPTY_ARRAY;
    private AngularViewElement[] angularViews = AngularViewElement.EMPTY_ARRAY;

    public CompilationUnitElementImpl(String string) {
        super(string, -1);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitCompilationUnitElement(this);
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && ((Object)this.source).equals(((CompilationUnitElementImpl)object).getSource());
    }

    @Override
    public PropertyAccessorElement[] getAccessors() {
        return this.accessors;
    }

    @Override
    public AngularViewElement[] getAngularViews() {
        return this.angularViews;
    }

    @Override
    public ElementImpl getChild(String string) {
        for (PropertyAccessorElement element : this.accessors) {
            if (!((PropertyAccessorElementImpl)element).getIdentifier().equals(string)) continue;
            return (PropertyAccessorElementImpl)element;
        }
        for (Element element : this.variables) {
            if (!((VariableElementImpl)element).getIdentifier().equals(string)) continue;
            return (VariableElementImpl)element;
        }
        for (Element element : this.functions) {
            if (!((ExecutableElementImpl)element).getIdentifier().equals(string)) continue;
            return (ExecutableElementImpl)element;
        }
        for (Element element : this.typeAliases) {
            if (!((FunctionTypeAliasElementImpl)element).getIdentifier().equals(string)) continue;
            return (FunctionTypeAliasElementImpl)element;
        }
        for (Element element : this.types) {
            if (!((ClassElementImpl)element).getIdentifier().equals(string)) continue;
            return (ClassElementImpl)element;
        }
        return null;
    }

    @Override
    public LibraryElement getEnclosingElement() {
        return (LibraryElement)super.getEnclosingElement();
    }

    @Override
    public FunctionElement[] getFunctions() {
        return this.functions;
    }

    @Override
    public FunctionTypeAliasElement[] getFunctionTypeAliases() {
        return this.typeAliases;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.COMPILATION_UNIT;
    }

    @Override
    public CompilationUnit getNode() throws AnalysisException {
        return this.getUnit();
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public TopLevelVariableElement[] getTopLevelVariables() {
        return this.variables;
    }

    @Override
    public ClassElement getType(String string) {
        for (ClassElement classElement : this.types) {
            if (!classElement.getName().equals(string)) continue;
            return classElement;
        }
        return null;
    }

    @Override
    public ClassElement[] getTypes() {
        return this.types;
    }

    @Override
    public int hashCode() {
        return ((Object)this.source).hashCode();
    }

    public void setAccessors(PropertyAccessorElement[] propertyAccessorElementArray) {
        for (PropertyAccessorElement propertyAccessorElement : propertyAccessorElementArray) {
            ((PropertyAccessorElementImpl)propertyAccessorElement).setEnclosingElement(this);
        }
        this.accessors = propertyAccessorElementArray;
    }

    public void setAngularViews(AngularViewElement[] angularViewElementArray) {
        for (AngularViewElement angularViewElement : angularViewElementArray) {
            ((AngularViewElementImpl)angularViewElement).setEnclosingElement(this);
        }
        this.angularViews = angularViewElementArray;
    }

    public void setFunctions(FunctionElement[] functionElementArray) {
        for (FunctionElement functionElement : functionElementArray) {
            ((FunctionElementImpl)functionElement).setEnclosingElement(this);
        }
        this.functions = functionElementArray;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setTopLevelVariables(TopLevelVariableElement[] topLevelVariableElementArray) {
        for (TopLevelVariableElement topLevelVariableElement : topLevelVariableElementArray) {
            ((TopLevelVariableElementImpl)topLevelVariableElement).setEnclosingElement(this);
        }
        this.variables = topLevelVariableElementArray;
    }

    public void setTypeAliases(FunctionTypeAliasElement[] functionTypeAliasElementArray) {
        for (FunctionTypeAliasElement functionTypeAliasElement : functionTypeAliasElementArray) {
            ((FunctionTypeAliasElementImpl)functionTypeAliasElement).setEnclosingElement(this);
        }
        this.typeAliases = functionTypeAliasElementArray;
    }

    public void setTypes(ClassElement[] classElementArray) {
        for (ClassElement classElement : classElementArray) {
            ((ClassElementImpl)classElement).setEnclosingElement(this);
        }
        this.types = classElementArray;
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.accessors, elementVisitor);
        this.safelyVisitChildren(this.functions, elementVisitor);
        this.safelyVisitChildren(this.typeAliases, elementVisitor);
        this.safelyVisitChildren(this.types, elementVisitor);
        this.safelyVisitChildren(this.variables, elementVisitor);
        this.safelyVisitChildren(this.angularViews, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        if (this.source == null) {
            stringBuilder.append("{compilation unit}");
        } else {
            stringBuilder.append(this.source.getFullName());
        }
    }

    @Override
    protected String getIdentifier() {
        return this.getSource().getEncoding();
    }

    ToolkitObjectElement[] getToolkitObjects(Element element) {
        ToolkitObjectElement[] toolkitObjectElementArray = this.toolkitObjects.get(element);
        if (toolkitObjectElementArray != null) {
            return toolkitObjectElementArray;
        }
        return ToolkitObjectElement.EMPTY_ARRAY;
    }

    void setToolkitObjects(Element element, ToolkitObjectElement[] toolkitObjectElementArray) {
        this.toolkitObjects.put(element, toolkitObjectElementArray);
    }
}

