/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.element;

import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.element.ConstructorElementImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.FieldElementImpl;
import com.google.dart.engine.internal.element.MethodElementImpl;
import com.google.dart.engine.internal.element.Modifier;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.ToolkitObjectElementImpl;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import com.google.dart.engine.internal.type.InterfaceTypeImpl;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;

public class ClassElementImpl
extends ElementImpl
implements ClassElement {
    private PropertyAccessorElement[] accessors = PropertyAccessorElementImpl.EMPTY_ARRAY;
    private ConstructorElement[] constructors = ConstructorElementImpl.EMPTY_ARRAY;
    private FieldElement[] fields = FieldElementImpl.EMPTY_ARRAY;
    private InterfaceType[] mixins = InterfaceTypeImpl.EMPTY_ARRAY;
    private InterfaceType[] interfaces = InterfaceTypeImpl.EMPTY_ARRAY;
    private MethodElement[] methods = MethodElementImpl.EMPTY_ARRAY;
    private InterfaceType supertype;
    private ToolkitObjectElement[] toolkitObjects = ToolkitObjectElement.EMPTY_ARRAY;
    private InterfaceType type;
    private TypeParameterElement[] typeParameters = TypeParameterElementImpl.EMPTY_ARRAY;
    public static final ClassElement[] EMPTY_ARRAY = new ClassElement[0];

    public ClassElementImpl(Identifier identifier) {
        super(identifier);
    }

    @Override
    public <R> R accept(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visitClassElement(this);
    }

    @Override
    public PropertyAccessorElement[] getAccessors() {
        return this.accessors;
    }

    @Override
    public InterfaceType[] getAllSupertypes() {
        ArrayList<InterfaceType> arrayList = new ArrayList<InterfaceType>();
        this.collectAllSupertypes(arrayList);
        return arrayList.toArray(new InterfaceType[arrayList.size()]);
    }

    @Override
    public ElementImpl getChild(String string) {
        for (PropertyAccessorElement element : this.accessors) {
            if (!((PropertyAccessorElementImpl)element).getIdentifier().equals(string)) continue;
            return (PropertyAccessorElementImpl)element;
        }
        for (ExecutableElement executableElement : this.constructors) {
            if (!((ConstructorElementImpl)executableElement).getIdentifier().equals(string)) continue;
            return (ConstructorElementImpl)executableElement;
        }
        for (Element element : this.fields) {
            if (!((FieldElementImpl)element).getIdentifier().equals(string)) continue;
            return (FieldElementImpl)element;
        }
        for (Element element : this.methods) {
            if (!((MethodElementImpl)element).getIdentifier().equals(string)) continue;
            return (MethodElementImpl)element;
        }
        for (Element element : this.typeParameters) {
            if (!((TypeParameterElementImpl)element).getIdentifier().equals(string)) continue;
            return (TypeParameterElementImpl)element;
        }
        return null;
    }

    @Override
    public ConstructorElement[] getConstructors() {
        return this.constructors;
    }

    @Override
    public FieldElement getField(String string) {
        for (FieldElement fieldElement : this.fields) {
            if (!string.equals(fieldElement.getName())) continue;
            return fieldElement;
        }
        return null;
    }

    @Override
    public FieldElement[] getFields() {
        return this.fields;
    }

    @Override
    public PropertyAccessorElement getGetter(String string) {
        for (PropertyAccessorElement propertyAccessorElement : this.accessors) {
            if (!propertyAccessorElement.isGetter() || !propertyAccessorElement.getName().equals(string)) continue;
            return propertyAccessorElement;
        }
        return null;
    }

    @Override
    public InterfaceType[] getInterfaces() {
        return this.interfaces;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CLASS;
    }

    @Override
    public MethodElement getMethod(String string) {
        for (MethodElement methodElement : this.methods) {
            if (!methodElement.getName().equals(string)) continue;
            return methodElement;
        }
        return null;
    }

    @Override
    public MethodElement[] getMethods() {
        return this.methods;
    }

    @Override
    public InterfaceType[] getMixins() {
        return this.mixins;
    }

    @Override
    public ConstructorElement getNamedConstructor(String string) {
        for (ConstructorElement constructorElement : this.getConstructors()) {
            String string2 = constructorElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return constructorElement;
        }
        return null;
    }

    @Override
    public ClassDeclaration getNode() throws AnalysisException {
        return this.getNodeMatching(ClassDeclaration.class);
    }

    @Override
    public PropertyAccessorElement getSetter(String string) {
        if (!StringUtilities.endsWithChar(string, 61)) {
            string = string + '=';
        }
        for (PropertyAccessorElement propertyAccessorElement : this.accessors) {
            if (!propertyAccessorElement.isSetter() || !propertyAccessorElement.getName().equals(string)) continue;
            return propertyAccessorElement;
        }
        return null;
    }

    @Override
    public InterfaceType getSupertype() {
        return this.supertype;
    }

    @Override
    public ToolkitObjectElement[] getToolkitObjects() {
        return this.toolkitObjects;
    }

    @Override
    public InterfaceType getType() {
        return this.type;
    }

    @Override
    public TypeParameterElement[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public ConstructorElement getUnnamedConstructor() {
        for (ConstructorElement constructorElement : this.getConstructors()) {
            String string = constructorElement.getDisplayName();
            if (string != null && !string.isEmpty()) continue;
            return constructorElement;
        }
        return null;
    }

    @Override
    public boolean hasNonFinalField() {
        ArrayList<ClassElement> arrayList = new ArrayList<ClassElement>();
        HashSet<ClassElement> hashSet = new HashSet<ClassElement>();
        arrayList.add(this);
        while (!arrayList.isEmpty()) {
            ClassElement classElement;
            ClassElement classElement2 = (ClassElement)arrayList.remove(0);
            if (!hashSet.add(classElement2)) continue;
            for (FieldElement fieldElement : classElement2.getFields()) {
                if (fieldElement.isFinal() || fieldElement.isConst() || fieldElement.isStatic() || fieldElement.isSynthetic()) continue;
                return true;
            }
            for (InterfaceType interfaceType : classElement2.getMixins()) {
                ClassElement classElement3 = interfaceType.getElement();
                arrayList.add(classElement3);
            }
            InterfaceType interfaceType = classElement2.getSupertype();
            if (interfaceType == null || (classElement = interfaceType.getElement()) == null) continue;
            arrayList.add(classElement);
        }
        return false;
    }

    @Override
    public boolean hasReferenceToSuper() {
        return this.hasModifier(Modifier.REFERENCES_SUPER);
    }

    @Override
    public boolean hasStaticMember() {
        for (MethodElement executableElement : this.methods) {
            if (!executableElement.isStatic()) continue;
            return true;
        }
        for (ExecutableElement executableElement : this.accessors) {
            if (!executableElement.isStatic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    @Override
    public boolean isOrInheritsProxy() {
        return this.safeIsOrInheritsProxy(this, new HashSet<ClassElement>());
    }

    @Override
    public boolean isProxy() {
        for (ElementAnnotation elementAnnotation : this.getMetadata()) {
            if (!elementAnnotation.isProxy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTypedef() {
        return this.hasModifier(Modifier.TYPEDEF);
    }

    @Override
    public boolean isValidMixin() {
        return this.hasModifier(Modifier.MIXIN);
    }

    @Override
    public PropertyAccessorElement lookUpGetter(String string, LibraryElement libraryElement) {
        HashSet<ClassElementImpl> hashSet = new HashSet<ClassElementImpl>();
        ClassElement classElement = this;
        while (classElement != null && !hashSet.contains(classElement)) {
            hashSet.add((ClassElementImpl)classElement);
            PropertyAccessorElement propertyAccessorElement = classElement.getGetter(string);
            if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
                return propertyAccessorElement;
            }
            for (InterfaceType interfaceType : classElement.getMixins()) {
                ClassElement classElement2 = interfaceType.getElement();
                if (classElement2 == null || (propertyAccessorElement = classElement2.getGetter(string)) == null || !propertyAccessorElement.isAccessibleIn(libraryElement)) continue;
                return propertyAccessorElement;
            }
            InterfaceType interfaceType = classElement.getSupertype();
            if (interfaceType == null) {
                return null;
            }
            classElement = interfaceType.getElement();
        }
        return null;
    }

    @Override
    public MethodElement lookUpMethod(String string, LibraryElement libraryElement) {
        HashSet<ClassElementImpl> hashSet = new HashSet<ClassElementImpl>();
        ClassElement classElement = this;
        while (classElement != null && !hashSet.contains(classElement)) {
            hashSet.add((ClassElementImpl)classElement);
            MethodElement methodElement = classElement.getMethod(string);
            if (methodElement != null && methodElement.isAccessibleIn(libraryElement)) {
                return methodElement;
            }
            for (InterfaceType interfaceType : classElement.getMixins()) {
                ClassElement classElement2 = interfaceType.getElement();
                if (classElement2 == null || (methodElement = classElement2.getMethod(string)) == null || !methodElement.isAccessibleIn(libraryElement)) continue;
                return methodElement;
            }
            InterfaceType interfaceType = classElement.getSupertype();
            if (interfaceType == null) {
                return null;
            }
            classElement = interfaceType.getElement();
        }
        return null;
    }

    @Override
    public PropertyAccessorElement lookUpSetter(String string, LibraryElement libraryElement) {
        HashSet<ClassElementImpl> hashSet = new HashSet<ClassElementImpl>();
        ClassElement classElement = this;
        while (classElement != null && !hashSet.contains(classElement)) {
            hashSet.add((ClassElementImpl)classElement);
            PropertyAccessorElement propertyAccessorElement = classElement.getSetter(string);
            if (propertyAccessorElement != null && propertyAccessorElement.isAccessibleIn(libraryElement)) {
                return propertyAccessorElement;
            }
            for (InterfaceType interfaceType : classElement.getMixins()) {
                ClassElement classElement2 = interfaceType.getElement();
                if (classElement2 == null || (propertyAccessorElement = classElement2.getSetter(string)) == null || !propertyAccessorElement.isAccessibleIn(libraryElement)) continue;
                return propertyAccessorElement;
            }
            InterfaceType interfaceType = classElement.getSupertype();
            if (interfaceType == null) {
                return null;
            }
            classElement = interfaceType.getElement();
        }
        return null;
    }

    public void setAbstract(boolean bl) {
        this.setModifier(Modifier.ABSTRACT, bl);
    }

    public void setAccessors(PropertyAccessorElement[] propertyAccessorElementArray) {
        for (PropertyAccessorElement propertyAccessorElement : propertyAccessorElementArray) {
            ((PropertyAccessorElementImpl)propertyAccessorElement).setEnclosingElement(this);
        }
        this.accessors = propertyAccessorElementArray;
    }

    public void setConstructors(ConstructorElement[] constructorElementArray) {
        for (ConstructorElement constructorElement : constructorElementArray) {
            ((ConstructorElementImpl)constructorElement).setEnclosingElement(this);
        }
        this.constructors = constructorElementArray;
    }

    public void setFields(FieldElement[] fieldElementArray) {
        for (FieldElement fieldElement : fieldElementArray) {
            ((FieldElementImpl)fieldElement).setEnclosingElement(this);
        }
        this.fields = fieldElementArray;
    }

    public void setHasReferenceToSuper(boolean bl) {
        this.setModifier(Modifier.REFERENCES_SUPER, bl);
    }

    public void setInterfaces(InterfaceType[] interfaceTypeArray) {
        this.interfaces = interfaceTypeArray;
    }

    public void setMethods(MethodElement[] methodElementArray) {
        for (MethodElement methodElement : methodElementArray) {
            ((MethodElementImpl)methodElement).setEnclosingElement(this);
        }
        this.methods = methodElementArray;
    }

    public void setMixins(InterfaceType[] interfaceTypeArray) {
        this.mixins = interfaceTypeArray;
    }

    public void setSupertype(InterfaceType interfaceType) {
        this.supertype = interfaceType;
    }

    public void setToolkitObjects(ToolkitObjectElement[] toolkitObjectElementArray) {
        for (ToolkitObjectElement toolkitObjectElement : toolkitObjectElementArray) {
            ((ToolkitObjectElementImpl)toolkitObjectElement).setEnclosingElement(this);
        }
        this.toolkitObjects = toolkitObjectElementArray;
    }

    public void setType(InterfaceType interfaceType) {
        this.type = interfaceType;
    }

    public void setTypedef(boolean bl) {
        this.setModifier(Modifier.TYPEDEF, bl);
    }

    public void setTypeParameters(TypeParameterElement[] typeParameterElementArray) {
        for (TypeParameterElement typeParameterElement : typeParameterElementArray) {
            ((TypeParameterElementImpl)typeParameterElement).setEnclosingElement(this);
        }
        this.typeParameters = typeParameterElementArray;
    }

    public void setValidMixin(boolean bl) {
        this.setModifier(Modifier.MIXIN, bl);
    }

    @Override
    public void visitChildren(ElementVisitor<?> elementVisitor) {
        super.visitChildren(elementVisitor);
        this.safelyVisitChildren(this.accessors, elementVisitor);
        this.safelyVisitChildren(this.constructors, elementVisitor);
        this.safelyVisitChildren(this.fields, elementVisitor);
        this.safelyVisitChildren(this.methods, elementVisitor);
        this.safelyVisitChildren(this.toolkitObjects, elementVisitor);
        this.safelyVisitChildren(this.typeParameters, elementVisitor);
    }

    @Override
    protected void appendTo(StringBuilder stringBuilder) {
        String string = this.getDisplayName();
        if (string == null) {
            stringBuilder.append("{unnamed class}");
        } else {
            stringBuilder.append(string);
        }
        int n = this.typeParameters.length;
        if (n > 0) {
            stringBuilder.append("<");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                ((TypeParameterElementImpl)this.typeParameters[i]).appendTo(stringBuilder);
            }
            stringBuilder.append(">");
        }
    }

    private void collectAllSupertypes(ArrayList<InterfaceType> arrayList) {
        ArrayList<InterfaceType> arrayList2 = new ArrayList<InterfaceType>();
        ArrayList<ClassElement> arrayList3 = new ArrayList<ClassElement>();
        arrayList2.add(this.getType());
        while (!arrayList2.isEmpty()) {
            InterfaceType interfaceType;
            InterfaceType interfaceType2 = (InterfaceType)arrayList2.remove(0);
            ClassElement classElement = interfaceType2.getElement();
            if (arrayList3.contains(classElement)) continue;
            arrayList3.add(classElement);
            if (interfaceType2 != this.getType()) {
                arrayList.add(interfaceType2);
            }
            if ((interfaceType = interfaceType2.getSuperclass()) != null) {
                arrayList2.add(interfaceType);
            }
            for (InterfaceType interfaceType3 : classElement.getInterfaces()) {
                arrayList2.add(interfaceType3);
            }
            for (InterfaceType interfaceType3 : classElement.getMixins()) {
                ClassElement classElement2 = interfaceType3.getElement();
                if (arrayList3.contains(classElement2)) continue;
                arrayList.add(interfaceType3);
            }
        }
    }

    private boolean safeIsOrInheritsProxy(ClassElement classElement, HashSet<ClassElement> hashSet) {
        int n;
        if (hashSet.contains(classElement)) {
            return false;
        }
        hashSet.add(classElement);
        if (classElement.isProxy()) {
            return true;
        }
        if (classElement.getSupertype() != null && this.safeIsOrInheritsProxy(classElement.getSupertype().getElement(), hashSet)) {
            return true;
        }
        InterfaceType[] interfaceTypeArray = classElement.getInterfaces();
        for (n = 0; n < interfaceTypeArray.length; ++n) {
            if (!this.safeIsOrInheritsProxy(interfaceTypeArray[n].getElement(), hashSet)) continue;
            return true;
        }
        interfaceTypeArray = classElement.getMixins();
        for (n = 0; n < interfaceTypeArray.length; ++n) {
            if (!this.safeIsOrInheritsProxy(interfaceTypeArray[n].getElement(), hashSet)) continue;
            return true;
        }
        return false;
    }
}

