/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.internal.context.SourcePriority;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class WorkManager {
    private ArrayList<Source>[] workQueues;

    public WorkManager() {
        int n = SourcePriority.values().length;
        this.workQueues = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            this.workQueues[i] = new ArrayList();
        }
    }

    public void add(Source source, SourcePriority sourcePriority) {
        int n = this.workQueues.length;
        int n2 = sourcePriority.ordinal();
        for (int i = 0; i < n; ++i) {
            ArrayList<Source> arrayList = this.workQueues[i];
            if (i == n2) {
                if (arrayList.contains(source)) continue;
                arrayList.add(source);
                continue;
            }
            arrayList.remove(source);
        }
    }

    public void addFirst(Source source, SourcePriority sourcePriority) {
        int n = this.workQueues.length;
        int n2 = sourcePriority.ordinal();
        for (int i = 0; i < n; ++i) {
            ArrayList<Source> arrayList = this.workQueues[i];
            if (i == n2) {
                arrayList.remove(source);
                arrayList.add(0, source);
                continue;
            }
            arrayList.remove(source);
        }
    }

    public WorkIterator iterator() {
        return new WorkIterator();
    }

    public void remove(Source source) {
        int n = this.workQueues.length;
        for (int i = 0; i < n; ++i) {
            this.workQueues[i].remove(source);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SourcePriority[] sourcePriorityArray = SourcePriority.values();
        boolean bl = false;
        int n = this.workQueues.length;
        for (int i = 0; i < n; ++i) {
            ArrayList<Source> arrayList = this.workQueues[i];
            if (arrayList.isEmpty()) continue;
            if (bl) {
                stringBuilder.append("; ");
            }
            stringBuilder.append((Object)sourcePriorityArray[i]);
            stringBuilder.append(": ");
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(arrayList.get(j).getFullName());
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public class WorkIterator {
        private int queueIndex = 0;
        private int index = -1;

        public WorkIterator() {
            this.advance();
        }

        public boolean hasNext() {
            return this.queueIndex < WorkManager.this.workQueues.length;
        }

        public Source next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Source source = (Source)WorkManager.this.workQueues[this.queueIndex].get(this.index);
            this.advance();
            return source;
        }

        private void advance() {
            ++this.index;
            if (this.index >= WorkManager.this.workQueues[this.queueIndex].size()) {
                this.index = 0;
                ++this.queueIndex;
                while (this.queueIndex < WorkManager.this.workQueues.length && WorkManager.this.workQueues[this.queueIndex].isEmpty()) {
                    ++this.queueIndex;
                }
            }
        }
    }
}

